define('FECRU/component/confirmDialog', ['jquery'], function ($) {

    var DIALOG_CLASS = 'confirm-dialog';
    var CONFIRM_BUTTON_CLASS = DIALOG_CLASS + '--confirm-button';
    var CANCEL_BUTTON_CLASS = DIALOG_CLASS + '--cancel-button';
    var SPINNER_PLACEHOLDER_CLASS = DIALOG_CLASS+'--spinner-placeholder';
    var SPINNER_PLACEHOLDER_HTML = '<div data-ref="spinner" class="'+SPINNER_PLACEHOLDER_CLASS+'"></div>';

    /**
     * @param {string} content
     * @param {string} title
     * @param {string} [options.confirmButtonLabel=Yes] label for confirm button
     * @param {string} [options.cancelButtonLabel=Cancel] label for cancel button
     * @param {string} [options.size=small] size of dialog
     * @param {string} [options.isWarning=true] is it a warning dialog?
     * @param {Function} [options.onConfirm] Function to call on confirm button click. Receives dialog instance as an argument
     * @param {Function} [options.onCancel] Function to call on cancel button click. Receives dialog instance as an argument
     */
    var func = function (title, content, options) {
        options = $.extend({}, {
            size: 'small',
            confirmButtonLabel: 'Yes',
            cancelButtonLabel: 'Cancel',
            onCancel: function (dialog) {
                dialog.hide();
            },
            isWarning: true,
            footerContent: func.renderButtons
        }, options);

        var dialog = AJS.dialog2($(aui.dialog.dialog2({
            titleText: title,
            content: content,
            size: options.size,
            removeOnHide: true,
            extraClasses: DIALOG_CLASS + (options.isWarning ? ' aui-dialog2-warning' : ''),
            footerActionContent: $.isFunction(options.footerContent) ? options.footerContent(options) : options.footerContent
        })));

        dialog.$el.find('.' + CONFIRM_BUTTON_CLASS).on('click', function () {
            options.onConfirm && options.onConfirm(dialog);
        });

        dialog.$el.find('.' + CANCEL_BUTTON_CLASS).on('click', function () {
            options.onCancel && options.onCancel(dialog);
        });

        dialog.show();
        return dialog;
    };

    func.renderButtonWithSpinnerPlaceholder = function (options) {
        return SPINNER_PLACEHOLDER_HTML + func.renderButtons(options);
    };

    func.renderButtons = function (options) {
        return aui.buttons.button({
                text: options.confirmButtonLabel,
                type: 'primary',
                extraClasses: CONFIRM_BUTTON_CLASS
            }) +
            aui.buttons.button({
                text: options.cancelButtonLabel,
                type: 'link',
                extraClasses: CANCEL_BUTTON_CLASS
            });
    };

    return func;
});