/**
 * Manager to register urls for fetching blame info.
 * By default blame component knows nothing about the endpoint that has to be used to fetch the data.
 * Once the source code is loaded it registers the url (requiring this manager and using `register` method).
 * Using that url we can access blame information for specific source.
 */

define('FECRU/component/blame/urls-manager', [
    'backbone'
], function (Backbone) {

    var urls = {};

    return _.extend({}, Backbone.Events, {

        /**
         * Register url or list of urls
         * @param config {Object|Array<Object>}
         */
        register: function (config) {
            Array.isArray(config) || (config = [config]);
            config.forEach(function (item) {
                urls[item.key] = item.url;
                this.trigger('registered', item);
            }, this);
        },

        /**
         * Get registered url by its key
         * @param key {string|number}
         * @returns {?string}
         */
        getUrl: function (key) {
            return urls[key] || null;
        },

        /**
         * Clear all registered urls
         */
        clear: function () {
            urls = {};
            this.trigger('cleared');
        }
    });

});
