/**
 * Renderer factory.
 * It provides a method that returns a new renderer instance based on input options.
 */

define('FECRU/component/blame/renderer', [
    'jquery',
    'backbone',
    'FECRU/component/blame/renderers/table-renderer-view',
    'FECRU/component/blame/renderers/block-renderer-view'
], function ($, Backbone, TableRendererView, BlockRendererView) {

    return {
        createView: function (options) {
            var el = options && options.el;
            if (el) {
                return $(el).prop('nodeName') === 'TABLE' ?
                    new TableRendererView(options) :
                    new BlockRendererView(options);
            }
            else {
                return new TableRendererView(options);
            }
        }
    }

});
