define('FECRU/component/blame/renderers/block-renderer-view', [
    'jquery',
    'underscore',
    'FECRU/component/blame/renderers/abstract-renderer-view',
    'FECRU/component/blame/templates'
], function ($, _, AbstractRendererView, templates) {

    return AbstractRendererView.extend({

        renderUnifiedBlameLine: function (lineNumber, $authors, $revisions, index) {
            var details = this.getChangesetDetailsForLineTo(lineNumber);
            if (details == null) {
                return;
            }

            if (lineNumber === details.found.to) {
                var metadata = this.model.getMetadata();
                var options = {
                    changesetId: details.found.changeset,
                    metadata: metadata,
                    details: details
                };
                $authors.eq(index).html(templates.authorCell(options));
                $revisions.eq(index).html(templates.revisionCell(options));
            }
        },

        /**
         * Currently source code rendered by JS doesn't have blame info in SBS mode.
         * So it will stay as is, we will just hide the button.
         */
        renderSideBySideBlameLine: function () {},

        /**
         * For source page we do not need to collect mandatory lines because of lack of diff/context.
         * So just do nothing.
         */
        collectMandatoryLines: function () {},

        /**
         * @override
         * Override the way blame info is rendered in unified diff mode.
         * Fix already rendered pages and listen to new pages render to be able to inject blame data immediately.
         */
        renderUnifiedBlameContent: function () {
            this.trackPageRender();
            this.renderAllPages();
            this.fixSourceCode();
        },

        showBlameArea: function () {
            this.$el.removeClass('blame-info__hidden');
            this.fixSourceCode();
        },

        hideBlameArea: function () {
            this.$el.addClass('blame-info__hidden');
            this.fixSourceCode();
        },

        isUnifiedDiff: function () {
            return this.$el.hasClass('view-annotation');
        },

        trackPageRender: function () {
            $(window).on('sbs-page:rendered', this.onPageRendered.bind(this));
        },

        onPageRendered: function (e, page) {
            this.renderPage(page);
        },

        renderPage: function (page) {
            var $authors = $(page.authBlameDom).children('pre');
            var $revisions = $(page.revBlameDom).children('pre');
            var lineRanges = _.range(page.lineStart, page.lineEnd + 1);

            this.renderLinesSmart(lineRanges, function (lineNumber) {
                this.renderUnifiedBlameLine(lineNumber, $authors, $revisions, lineNumber - page.lineStart);
            });
        },

        renderAllPages: function () {
            var blocks = this.getToBlocks();
            var filtered = _.flatten(_.values(blocks).map(function (block) {
                return block.filter(_.isObject);
            }));

            if (filtered.length) {
                filtered.forEach(this.renderPage, this);
            }
        },

        /**
         * Get all to blocks source code has.
         * @returns {Object}
         */
        getToBlocks: function () {
            return this.getFramesSbsObject().getDiff().to.blocks;
        },

        /**
         * Get SBS object from the iframe where source code is rendered.
         * @returns {Object}
         */
        getFramesSbsObject: function () {
            return window['file-view-source-content'].FECRU.SBS;
        },

        /**
         * This method invokes `resize` one that takes care about source blocks recalculation.
         * Also it simulates the scroll so all blocks (with numbers, revisions, the code itself etc) are synchronized.
         * Because everything is hardcoded this step is mandatory.
         */
        fixSourceCode: function () {
            this.getFramesSbsObject().resize(true);
            this.getFramesSbsObject().simulateScroll();
        }

    });

});
