define('FECRU/component/blame/renderers/abstract-renderer-view', [
    'jquery',
    'underscore',
    'backbone'
], function ($, _, Backbone) {

    var IMPLEMENTATION_MISSED_MESSAGE = 'Implementation for method is missed';

    return Backbone.View.extend({

        el: '.blame-info:visible',

        renderUnifiedBlameLine: function () {
            throw new Error(IMPLEMENTATION_MISSED_MESSAGE);
        },

        renderSideBySideBlameLine: function () {
            throw new Error(IMPLEMENTATION_MISSED_MESSAGE);
        },

        /**
         * This method has to create a list with lines that will be forced to display blame info.
         * It has to be implemented and used by renderer.
         * For example, when:
         *   - this is the first line in the file
         *   - the line above is empty or not a source line (was removed in SBS diff, "context=Number" break etc.)
         *   - the line was removed/added
         *   - the line goes after removed/added one
         */
        collectMandatoryLines: function () {
            throw new Error(IMPLEMENTATION_MISSED_MESSAGE);
        },

        renderBlameContent: function () {
            this.$el.addClass('blame-info__rendered');
            this.collectMandatoryLines();
            this.isUnifiedDiff() ?
                this.renderUnifiedBlameContent() :
                this.renderSideBySideBlameContent();
        },

        renderUnifiedBlameContent: function () {
            this.renderLinesSmart(this.getAllSourceLines(), this.renderUnifiedBlameLine);
        },

        renderSideBySideBlameContent: function () {
            this.renderLinesSmart(this.getAllSourceLines(), this.renderSideBySideBlameLine);
        },

        /**
         * Render lines in batches - no more then 100 lines at once.
         * If there are more lines to render - schedule rendering in the next event loop.
         * @param trs {NodeList}
         * @param renderLineFn {function}
         */
        renderLinesSmart: function (trs, renderLineFn) {
            var maxRendersAtOnce = 100;
            var index = 0;
            var rendered = 0;
            while (rendered < maxRendersAtOnce) {
                var tr = trs[index];
                if (tr == null) {
                    return;
                }
                rendered += renderLineFn.call(this, tr) ? 1 : 0;
                index++;
            }

            var restTrs = trs.slice(index);
            if (restTrs.length) {
                setTimeout(this.renderLinesSmart.bind(this, restTrs, renderLineFn));
            }
        },

        isUnifiedDiff: function () {
            return this.$el.hasClass('unifiedDiff');
        },

        getAllSourceLines: function () {
            return this.__allSourceLines || (this.__allSourceLines = this.$('.sourceLine, .commentableLine'));
        },

        getAllSkippedLines: function () {
            return this.__allSkippedLines || (this.__allSkippedLines = this.$('.diffSkipped'));
        },

        getChangesetDetailsForLineFrom: function (line) {
            return this.model.getChangesetDetailsForLine(line, 'from');
        },

        getChangesetDetailsForLineTo: function (line) {
            return this.model.getChangesetDetailsForLine(line, 'to');
        },

        showBlameArea: function () {
            this.$el.removeClass('blame-info__hidden');
        },

        hideBlameArea: function () {
            this.$el.addClass('blame-info__hidden');
        },

        getLinesNumbers: function ($tr) {
            return {
                from: $tr.data('from'),
                to: $tr.data('to')
            };
        }

    });

});
