define('FECRU/component/blame/blame-instance', [
    'backbone',
    'global-ns/fecru-event-bus',
    'FECRU/component/blame/urls-manager',
    'FECRU/component/blame/model',
    'FECRU/component/blame/trigger-view',
    'FECRU/component/blame/renderer'
], function (Backbone, eventBus, urlsManager, BlameModel, BlameTriggerView, blameRenderer) {

    /**
     * @param key {string}
     * @param [page] {string} Page identificator
     * @param [$source] {jQuery} Source code element
     * @constructor
     */
    function BlameInstance(key, page, $source) {
        this.key = key;
        this.page = page;
        this.$source = $source;
        this.eventBus = _.extend({}, Backbone.Events);
        this.model = new BlameModel(null, {url: this.getUrl()});
        this.triggerView = new BlameTriggerView({model: this.model});

        var rendererOptions = {model: this.model};
        if ($source) {
            rendererOptions.el = $source;
        }
        this.rendererView = blameRenderer.createView(rendererOptions);
    }

    BlameInstance.prototype = {
        init: function () {
            this.triggerView.init();
            this.attachEvents();
        },

        reset: function () {
            this.triggerView.reset();
            this.detachEvents();
        },

        /**
         * Returns registered url by instance's key
         * @returns {?string}
         */
        getUrl: function () {
            return urlsManager.getUrl(this.key);
        },

        /**
         * Checks whether or not blame info can be fetched
         * @returns {boolean}
         */
        canFetchBlameInfo: function () {
            return !!this.model.url;
        },

        attachEvents: function () {
            var rendererView = this.rendererView;
            this.eventBus.listenTo(eventBus, 'SHOW_BLAME_AREA', rendererView.showBlameArea.bind(rendererView));
            this.eventBus.listenTo(eventBus, 'HIDE_BLAME_AREA', rendererView.hideBlameArea.bind(rendererView));
            this.eventBus.listenTo(eventBus, 'RENDER_BLAME_INFO', rendererView.renderBlameContent.bind(rendererView));
        },

        detachEvents: function () {
            this.eventBus.stopListening();
        }
    };

    return BlameInstance;

});
