@echo off
REM =============================================================
REM Initialise all of the required parameters to begin with.
REM =============================================================

REM Set the service name for windows service
set SERVICE_NAME=

REM Set up JAVA_HOME
set JAVA_HOME=%FISHEYE_HOME%\jre

REM Set the service description
set PR_DESCRIPTION=Atlassian FishEye Crucible Server

REM Set the installation directory TODO: Split this exe up dependant on System architecture.
set PR_INSTALL=%FISHEYE_HOME%\bin\fecru64.exe

set PR_MANAGE=%FISHEYE_HOME%\bin\prunmgr.exe

REM Service log configuration
set PR_LOGPREFIX=%SERVICE_NAME%
set PR_LOGPATH=%FISHEYE_INST%\service-logs
set PR_STDOUTPUT=%PR_LOGPATH%\stdout.txt
set PR_STDERROR=%PR_LOGPATH%\stderr.txt
set PR_LOGLEVEL=Error

REM Path to java installation
set PR_JVM=%FISHEYE_HOME%\jre\bin\server\jvm.dll
set PR_CLASSPATH=%FISHEYE_HOME%\fisheyeboot.jar

REM Startup configuration
set PR_STARTUP=auto
set PR_STARTMODE=jvm
set PR_STARTCLASS=com.cenqua.fisheye.FishEyeCtl
set PR_STARTPARAMS=run

REM Shutdown configuration
set PR_STOPMODE=jvm
set PR_STOPCLASS=com.cenqua.fisheye.FishEyeCtl
set PR_STOPPARAMS=stop

REM Skip default FISHEYE_OPTS if FISHEYE_OPTS have already been specified
if NOT "%FISHEYE_OPTS%" == "" goto :skipDefaultFishEyeOpts

REM Take the fecru options from the fisheyeboot.jar (Jump in to JAVA_HOME to use particular java)
pushd "%JAVA_HOME%\bin"
For /F "Tokens=*" %%I in ('java.exe -cp "%FISHEYE_HOME%\fisheyeboot.jar" com.cenqua.fisheye.boot.OptsSetter') Do Set FISHEYE_OPTS=%%I
popd

:skipDefaultFishEyeOpts
set PR_JVMOPTIONS=-Dfisheye.library.path=%FISHEYE_LIBRARY_PATH%;-Dfisheye.inst=%FISHEYE_INST%;-Djava.awt.headless=true;-Dfile.encoding=UTF-8;-Djava.endorsed.dirs=%FISHEYE_HOME%\lib\endorsed;%FISHEYE_OPTS: =;%

REM =============================================================
REM Parse params to decide what to do
REM =============================================================

if "%1" == "" goto displayUsage
if %1 == start goto start
if %1 == stop goto stop
if %1 == install goto install
if %1 == uninstall goto uninstall
if %1 == update goto update
if %1 == manage goto manage

REM fall through to display usage and exit if no option was parsed

:displayUsage
echo Usage: service.bat [ start|stop|install|uninstall|update ]
goto end

:manage
"%PR_MANAGE%" "//ES/%SERVICE_NAME%"
goto end

:stop
"%PR_INSTALL%" "//SS//%SERVICE_NAME%"
goto end

:uninstall
REM Stop and then Delete old service
"%PR_INSTALL%" "//DS//%SERVICE_NAME%"
goto end

:install
REM Install new service and then start it
"%PR_INSTALL%" "//IS//%SERVICE_NAME%"

:start
REM Run service
"%PR_INSTALL%" "//ES//%SERVICE_NAME%"
goto end

:update
REM Update service
"%PR_INSTALL%" "//DS//%SERVICE_NAME%"
"%PR_INSTALL%" "//IS//%SERVICE_NAME%"
"%PR_INSTALL%" "//ES//%SERVICE_NAME%"
goto end

:end
