@echo off


@setlocal

set FISHEYE_HOME=%~dp0..

if exist "%FISHEYE_HOME%\fisheyeboot.jar" goto haveFishEye

echo Could not find "%FISHEYE_HOME%\fisheyeboot.jar"
goto end

:haveFishEye



set _JAVACMD=%JAVACMD%


if not defined JAVA_HOME goto noJavaHome
if not exist "%JAVA_HOME%\bin\java.exe" goto noJavaHome
if not defined _JAVACMD set _JAVACMD=%JAVA_HOME%\bin\java.exe

if exist "%_JAVACMD%" goto haveJava
echo Could not find "%_JAVACMD%", please set the JAVA_HOME or JAVACMD environment variable,
echo or ensure java.exe is in the PATH.
goto end

:noJavaHome
if "%_JAVACMD%" == "" goto checkJavaInstalled
goto haveJava

:checkJavaInstalled
for %%X in (java.exe) do (set FOUND=%%~$PATH:X)
if not defined FOUND goto noJavaInstalled
set _JAVACMD=java.exe
goto haveJava

:noJavaInstalled
echo.
echo -----------------------------------------------------------------------
echo.
echo This software requires the Java Runtime Environment 1.8.0 or newer.
echo Please download and install a recent Java distribution from:
echo.
echo   http://www.java.com/download/
echo.
echo If Java is already installed, please ensure that your JAVA_HOME
echo environment variable is set or java.exe is accessible on your PATH.
echo For more information about setting JAVA_HOME, please see:
echo.
echo   http://confluence.atlassian.com/display/FISHEYE/Setting+JAVA_HOME
echo.
echo -----------------------------------------------------------------------
echo.
goto end

:haveJava
if "%FISHEYE_INST%" == "" set FISHEYE_INST=%FISHEYE_HOME%
set _EXECCMD="%_JAVACMD%"
if "%1" == "start" goto doStart
goto doExec

:doStart
set _EXECCMD=start "FishEye" "%_JAVACMD%"

:doExec

rem    Switching directory below is a hack to workaround the case where both the java executable and fisheyeboot.jar
rem    reside in directories that contain spaces in their paths (quoting both the executable and the -cp switch fails)
rem    Changing to the script directory ($~dp0) allows us to specify a relative classpath. (see FECRU-172)

set WORK_DIR=%CD%
set BAT_DIR=%~dp0
cd %BAT_DIR%
For /F "Tokens=*" %%I in ('"%_JAVACMD%" -cp ..\fisheyeboot.jar com.cenqua.fisheye.boot.OptsSetter') Do Set FISHEYE_OPTS=%%I
cd %WORK_DIR%

%_EXECCMD% %FISHEYE_OPTS%  "-Dfisheye.library.path=%FISHEYE_LIBRARY_PATH%" "-Dfisheye.inst=%FISHEYE_INST%" -Djava.awt.headless=true "-Djava.endorsed.dirs=%FISHEYE_HOME%\lib\endorsed" -jar "%FISHEYE_HOME%\fisheyeboot.jar" %* %FISHEYE_ARGS%
if "%1" == "start" goto end
if errorlevel 1 pause
goto end


:end
rem all done

@endlocal


