/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.webfragments;

import com.atlassian.fisheye.plugin.web.helpers.DefaultHelper;
import com.atlassian.fisheye.plugin.web.helpers.DefaultHelperFactory;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.atlassian.plugin.web.model.WebLabel;
import com.cenqua.fisheye.web.webfragments.DefaultInjectableWebFragmentDataFactory;
import com.cenqua.fisheye.web.webfragments.WebItemData;
import com.cenqua.fisheye.web.webfragments.WebSectionData;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultInjectableWebFragmentDataFactoryTest {
    private WebInterfaceManager webInterfaceManager;
    private DefaultHelperFactory helperFactory;
    private DefaultInjectableWebFragmentDataFactory webFragmentDataFactory;
    private DefaultHelper helper;
    private static Function<WebSectionData, String> SECTION_TO_KEY = WebSectionData::getKey;
    private static Function<WebItemData, String> ITEM_TO_KEY = WebItemData::getModuleKey;

    @Before
    public void setUp() throws Exception {
        this.webInterfaceManager = (WebInterfaceManager)Mockito.mock(WebInterfaceManager.class);
        this.helper = (DefaultHelper)Mockito.mock(DefaultHelper.class);
        this.helperFactory = (DefaultHelperFactory)Mockito.mock(DefaultHelperFactory.class);
        Mockito.when((Object)this.helperFactory.forRequest((HttpServletRequest)org.mockito.Matchers.any(HttpServletRequest.class))).thenReturn((Object)this.helper);
        this.webFragmentDataFactory = new DefaultInjectableWebFragmentDataFactory(this.webInterfaceManager, this.helperFactory);
    }

    @Test
    public void testGetWebSectionsWithItems() throws Exception {
        String sectionsLocation = "something";
        String itemsSection = "something/a";
        ImmutableList sectionDescriptors = ImmutableList.of((Object)this.createSectionDescriptor("a", "Section a", sectionsLocation));
        Mockito.when((Object)this.webInterfaceManager.getDisplayableSections((String)org.mockito.Matchers.eq((Object)sectionsLocation), org.mockito.Matchers.anyMap())).thenReturn((Object)sectionDescriptors);
        ImmutableList itemDescriptors = ImmutableList.of((Object)this.createItemDescriptor("1", "Item 1", itemsSection), (Object)this.createItemDescriptor("2", "Item 2", itemsSection));
        Mockito.when((Object)this.webInterfaceManager.getDisplayableItems((String)org.mockito.Matchers.eq((Object)itemsSection), org.mockito.Matchers.anyMap())).thenReturn((Object)itemDescriptors);
        List sections = this.webFragmentDataFactory.getWebSections(null, sectionsLocation, true);
        Assert.assertThat((Object)Iterables.transform((Iterable)sections, SECTION_TO_KEY), (Matcher)Matchers.contains((Object[])new String[]{"a"}));
        Assert.assertThat((Object)Iterables.transform((Iterable)((WebSectionData)sections.get(0)).getItems(), ITEM_TO_KEY), (Matcher)Matchers.contains((Object[])new String[]{"1", "2"}));
    }

    private WebSectionModuleDescriptor createSectionDescriptor(String key, String label, String location) {
        WebSectionModuleDescriptor descriptor = (WebSectionModuleDescriptor)Mockito.mock(WebSectionModuleDescriptor.class);
        Mockito.when((Object)descriptor.getName()).thenReturn((Object)key);
        Mockito.when((Object)descriptor.getCompleteKey()).thenReturn((Object)key);
        Mockito.when((Object)descriptor.getLocation()).thenReturn((Object)location);
        WebLabel webLabel = this.createWebLabel(label);
        Mockito.when((Object)descriptor.getWebLabel()).thenReturn((Object)webLabel);
        return descriptor;
    }

    private WebItemModuleDescriptor createItemDescriptor(String key, String label, String section) {
        WebItemModuleDescriptor descriptor = (WebItemModuleDescriptor)Mockito.mock(WebItemModuleDescriptor.class);
        Mockito.when((Object)descriptor.getName()).thenReturn((Object)key);
        Mockito.when((Object)descriptor.getCompleteKey()).thenReturn((Object)key);
        Mockito.when((Object)descriptor.getSection()).thenReturn((Object)section);
        WebLabel webLabel = this.createWebLabel(label);
        Mockito.when((Object)descriptor.getWebLabel()).thenReturn((Object)webLabel);
        return descriptor;
    }

    private WebLabel createWebLabel(String label) {
        WebLabel webLabel = (WebLabel)Mockito.mock(WebLabel.class);
        Mockito.when((Object)webLabel.getKey()).thenReturn((Object)label);
        Mockito.when((Object)webLabel.getDisplayableLabel((HttpServletRequest)org.mockito.Matchers.any(HttpServletRequest.class), org.mockito.Matchers.anyMap())).thenReturn((Object)label);
        return webLabel;
    }
}

