/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.cenqua.fisheye.web.util.WrappedRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import junit.framework.Assert;
import org.apache.commons.lang.ArrayUtils;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public final class WrappedRequestTest {
    private final Map<String, String[]> params = new HashMap<String, String[]>();
    private HttpServletRequest request;
    private WrappedRequest wrappedRequest;

    @Before
    public void setUp() throws Exception {
        this.request = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)this.request.getParameter((String)EasyMock.isA(String.class))).andStubAnswer(() -> {
            String[] v = this.params.get(EasyMock.getCurrentArguments()[0]);
            return v == null || v.length < 1 ? null : v[0];
        });
        EasyMock.expect((Object)this.request.getParameterMap()).andStubReturn(Collections.unmodifiableMap(this.params));
        EasyMock.expect((Object)this.request.getParameterNames()).andStubAnswer(() -> Collections.enumeration(this.params.keySet()));
        EasyMock.expect((Object)this.request.getParameterValues((String)EasyMock.isA(String.class))).andStubAnswer(() -> this.params.get(EasyMock.getCurrentArguments()[0]));
        this.wrappedRequest = new WrappedRequest(this.request);
    }

    @Test
    public void testConstructorWhenRequestIsNull() {
        try {
            new WrappedRequest(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException or NullPointerException.");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetSetParameter() {
        EasyMock.replay((Object[])new Object[]{this.request});
        this.wrappedRequest.setParameter("foo", "bar");
        Assert.assertEquals((String)"bar", (String)this.wrappedRequest.getParameter("foo"));
    }

    @Test
    public void testSetParameterNameToNull() {
        EasyMock.replay((Object[])new Object[]{this.request});
        try {
            this.wrappedRequest.setParameter(null, "bar");
            Assert.fail((String)"Should have thrown IllegalArgumentException when name is null.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetParameterNameToEmpty() {
        EasyMock.replay((Object[])new Object[]{this.request});
        try {
            this.wrappedRequest.setParameter("", "bar");
            Assert.fail((String)"Should have thrown IllegalArgumentException when name is empty.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetParameterValueToNull() {
        EasyMock.replay((Object[])new Object[]{this.request});
        try {
            this.wrappedRequest.setParameter("foo", null);
            Assert.fail((String)"Should have thrown IllegalArgumentException when value is null.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetParameterOriginal() {
        this.params.put("foo", new String[]{"bar"});
        EasyMock.replay((Object[])new Object[]{this.request});
        Assert.assertEquals((String)"bar", (String)this.wrappedRequest.getParameter("foo"));
    }

    @Test
    public void testGetParameterOriginalMasked() {
        this.params.put("foo", new String[]{"foo0"});
        EasyMock.replay((Object[])new Object[]{this.request});
        this.wrappedRequest.setParameter("foo", "foo1");
        Assert.assertEquals((String)"foo1", (String)this.wrappedRequest.getParameter("foo"));
        EasyMock.verify((Object[])new Object[]{this.request});
    }

    @Test
    public void testGetParameterWithNewParamAddedToOriginalAfterWrapping() {
        this.params.put("foo", new String[]{"foo0"});
        EasyMock.replay((Object[])new Object[]{this.request});
        this.wrappedRequest.setParameter("bar", "bar0");
        this.params.put("baz", new String[]{"baz1"});
        Assert.assertEquals((String)"foo0", (String)this.wrappedRequest.getParameter("foo"));
        Assert.assertEquals((String)"bar0", (String)this.wrappedRequest.getParameter("bar"));
        Assert.assertEquals((String)"baz1", (String)this.wrappedRequest.getParameter("baz"));
        EasyMock.verify((Object[])new Object[]{this.request});
    }

    @Test
    public void testGetParameterMapOriginal() {
        this.params.put("foo", new String[]{"bar"});
        EasyMock.replay((Object[])new Object[]{this.request});
        Assert.assertEquals(this.params, (Object)this.wrappedRequest.getParameterMap());
    }

    @Test
    public void testGetParameterMapOriginalMasked() {
        this.params.put("foo", new String[]{"foo0"});
        EasyMock.replay((Object[])new Object[]{this.request});
        this.wrappedRequest.setParameter("foo", "foo1");
        HashMap<String, String[]> expected = new HashMap<String, String[]>(this.params);
        expected.put("foo", new String[]{"foo1"});
        this.assertParameterMapEquals(expected, this.wrappedRequest.getParameterMap());
        EasyMock.verify((Object[])new Object[]{this.request});
    }

    @Test
    public void testGetParameterMapWithNewParamAddedToOriginalAfterWrapping() {
        this.params.put("foo", new String[]{"foo0"});
        EasyMock.replay((Object[])new Object[]{this.request});
        this.wrappedRequest.setParameter("bar", "bar0");
        this.params.put("baz", new String[]{"baz1"});
        HashMap<String, String[]> expected = new HashMap<String, String[]>(this.params);
        expected.put("bar", new String[]{"bar0"});
        expected.put("baz", new String[]{"baz1"});
        this.assertParameterMapEquals(expected, this.wrappedRequest.getParameterMap());
        EasyMock.verify((Object[])new Object[]{this.request});
    }

    @Test
    public void testGetParameterNamesOriginal() {
        this.params.put("foo", new String[]{"bar"});
        EasyMock.replay((Object[])new Object[]{this.request});
        Assert.assertEquals(this.toSet("foo"), this.toSet(this.wrappedRequest.getParameterNames()));
        EasyMock.verify((Object[])new Object[]{this.request});
    }

    @Test
    public void testGetParameterNamesOriginalMasked() {
        this.params.put("foo", new String[]{"foo0"});
        EasyMock.replay((Object[])new Object[]{this.request});
        this.wrappedRequest.setParameter("foo", "foo1");
        Assert.assertEquals(this.toSet("foo"), this.toSet(this.wrappedRequest.getParameterNames()));
        EasyMock.verify((Object[])new Object[]{this.request});
    }

    @Test
    public void testGetParameterNamesWithNewParamAddedToOriginalAfterWrapping() {
        this.params.put("foo", new String[]{"foo0"});
        EasyMock.replay((Object[])new Object[]{this.request});
        this.wrappedRequest.setParameter("bar", "bar0");
        this.params.put("baz", new String[]{"baz1"});
        Assert.assertEquals(this.toSet("foo", "bar", "baz"), this.toSet(this.wrappedRequest.getParameterNames()));
        EasyMock.verify((Object[])new Object[]{this.request});
    }

    @Test
    public void testGetParameterValuesOriginal() {
        this.params.put("foo", new String[]{"bar"});
        EasyMock.replay((Object[])new Object[]{this.request});
        this.assertArrayEquals(new String[]{"bar"}, this.wrappedRequest.getParameterValues("foo"));
    }

    @Test
    public void testGetParameterValuesOriginalMasked() {
        this.params.put("foo", new String[]{"foo0"});
        EasyMock.replay((Object[])new Object[]{this.request});
        this.wrappedRequest.setParameter("foo", "foo1");
        this.assertArrayEquals(new String[]{"foo1"}, this.wrappedRequest.getParameterValues("foo"));
        EasyMock.verify((Object[])new Object[]{this.request});
    }

    @Test
    public void testGetParameterValuesWithNewParamAddedToOriginalAfterWrapping() {
        this.params.put("foo", new String[]{"foo0"});
        EasyMock.replay((Object[])new Object[]{this.request});
        this.wrappedRequest.setParameter("bar", "bar0");
        this.params.put("baz", new String[]{"baz1"});
        this.assertArrayEquals(new String[]{"foo0"}, this.wrappedRequest.getParameterValues("foo"));
        this.assertArrayEquals(new String[]{"bar0"}, this.wrappedRequest.getParameterValues("bar"));
        this.assertArrayEquals(new String[]{"baz1"}, this.wrappedRequest.getParameterValues("baz"));
        EasyMock.verify((Object[])new Object[]{this.request});
    }

    private void assertParameterMapEquals(Map<String, String[]> expected, Map<String, String[]> actual) {
        if (expected == null) {
            Assert.assertNull(actual);
            return;
        }
        Assert.assertNotNull(actual);
        Assert.assertEquals((int)expected.size(), (int)actual.size());
        for (String key : expected.keySet()) {
            Assert.assertTrue((String)("Should contain key [" + key + "]."), (boolean)actual.containsKey(key));
            Assert.assertTrue((String)("Value should equal for key [" + key + "]. Expected: [" + ArrayUtils.toString((Object)expected.get(key)) + "]. Actual: [" + ArrayUtils.toString((Object)actual.get(key)) + "]."), (boolean)ArrayUtils.isEquals((Object)expected.get(key), (Object)actual.get(key)));
        }
    }

    private Set<String> toSet(String ... values) {
        return new HashSet<String>(Arrays.asList(values));
    }

    private Set<String> toSet(Enumeration<String> enumeration) {
        HashSet<String> result = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            result.add(enumeration.nextElement());
        }
        return result;
    }

    private void assertArrayEquals(Object[] expected, Object[] actual) {
        Assert.assertTrue((String)("Expected: [" + ArrayUtils.toString((Object)expected) + "]. Actual: [" + ArrayUtils.toString((Object)actual) + "]."), (boolean)ArrayUtils.isEquals((Object)expected, (Object)actual));
    }
}

