/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.web.util.SafeRedirectChecker;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SafeRedirectCheckerTest {
    RootConfig rootConfig = (RootConfig)Mockito.mock(RootConfig.class);
    SafeRedirectChecker safeRedirectChecker = new SafeRedirectChecker(this.rootConfig);

    @Test
    public void testNull() {
        Assert.assertTrue((boolean)this.check(null));
        Assert.assertTrue((boolean)this.check(""));
    }

    @Test
    public void testRelative() {
        Assert.assertTrue((boolean)this.check("/foo/bar"));
    }

    @Test
    public void testGoodAbsolute() {
        Assert.assertTrue((boolean)this.check("http://foo.com/bar/baz"));
    }

    @Test
    public void testBadAbsolute() {
        Assert.assertFalse((boolean)this.check("http://google.com"));
    }

    @Test
    public void testDeceptiveHost() {
        Assert.assertFalse((boolean)this.check("http://foo.com.au"));
    }

    @Test
    public void testIdentical() {
        Assert.assertTrue((boolean)this.check("http://foo.com/bar"));
        Assert.assertTrue((boolean)this.checkWithoutContext("http://foo.com"));
    }

    @Test
    public void testScheme() {
        Assert.assertFalse((boolean)this.check("https://foo.com/bar"));
    }

    @Test
    public void testDeceptiveContext() {
        Assert.assertFalse((boolean)this.checkWithContext("http://foo.com/barfly"));
    }

    @Test
    public void testExplicitPorts() {
        Assert.assertTrue((boolean)this.checkWithoutContext("http://foo.com:80"));
        Assert.assertTrue((boolean)this.checkHttpsWithoutContext("https://foo.com:443"));
    }

    @Test
    public void testOddScheme() {
        Assert.assertTrue((boolean)this.checkWithoutContext("xxx", "xxx://foo.com"));
    }

    private boolean checkHttpsWithoutContext(String s) {
        return this.checkWithoutContext("https", s);
    }

    private boolean check(String s) {
        boolean withContext = this.checkWithContext(s);
        boolean withoutContext = this.checkWithoutContext(s);
        Assert.assertEquals((Object)withContext, (Object)withoutContext);
        return withContext;
    }

    private boolean checkWithContext(String s) {
        Mockito.when((Object)this.rootConfig.getSiteURL()).thenReturn((Object)"http://foo.com/bar");
        return this.safeRedirectChecker.canRedirectTo(s);
    }

    private boolean checkWithoutContext(String s) {
        return this.checkWithoutContext("http", s);
    }

    private boolean checkWithoutContext(String scheme, String s) {
        Mockito.when((Object)this.rootConfig.getSiteURL()).thenReturn((Object)(scheme + "://foo.com"));
        return this.safeRedirectChecker.canRedirectTo(s);
    }
}

