/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.cenqua.fisheye.web.tags.AsJavascriptStringTag;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.cenqua.fisheye.web.util.JavascriptObfuscator;
import java.io.IOException;
import junit.framework.TestCase;

public class JavascriptObfuscatorTest
extends TestCase {
    public void testEmptyString() throws IOException {
        this.checkObfuscatedString("");
    }

    public void testSimpleString() throws IOException {
        this.checkObfuscatedString("abcd");
    }

    public void testQuotesString() throws IOException {
        this.checkObfuscatedString("ab'cd");
        this.checkObfuscatedString("ab\"cd");
    }

    private void checkObfuscatedString(String original) throws IOException {
        String s = JavascriptObfuscator.insertObfuscatedString((String)original);
        JavascriptObfuscatorTest.assertTrue((boolean)s.startsWith("<script type=\"text/javascript\" id=\"to-removed\">eval(decodeURIComponent('"));
        JavascriptObfuscatorTest.assertTrue((boolean)s.endsWith("'));\nvar scriptElem = document.getElementById('to-removed')\nscriptElem.parentNode.removeChild(scriptElem);\n</script>"));
        String payload = s.substring("<script type=\"text/javascript\" id=\"to-removed\">eval(decodeURIComponent('".length(), s.length() - "'));\nvar scriptElem = document.getElementById('to-removed')\nscriptElem.parentNode.removeChild(scriptElem);\n</script>".length());
        String decoded = FishEyeURLEncoder.decode((String)payload);
        JavascriptObfuscatorTest.assertTrue((boolean)decoded.startsWith("document.write(\""));
        JavascriptObfuscatorTest.assertTrue((boolean)decoded.endsWith("\")"));
        String text = decoded.substring("document.write(\"".length(), decoded.length() - "\")".length());
        JavascriptObfuscatorTest.assertEquals((String)AsJavascriptStringTag.escapeString((String)original), (String)text);
    }
}

