/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FishEyeURLEncoderTest {
    private String unreservedCharacters;

    @Before
    public void setUp() {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 97; i <= 122; ++i) {
            sb.append((char)i);
        }
        for (i = 65; i <= 90; ++i) {
            sb.append((char)i);
        }
        for (i = 48; i <= 57; ++i) {
            sb.append((char)i);
        }
        sb.append('-');
        sb.append('.');
        sb.append('_');
        sb.append('~');
        this.unreservedCharacters = sb.toString();
    }

    @After
    public void tearDown() {
        this.unreservedCharacters = null;
    }

    @Test
    public void testUriEncodeUnreserved() {
        Assert.assertEquals((Object)this.unreservedCharacters, (Object)FishEyeURLEncoder.uriEncode((String)this.unreservedCharacters));
    }

    @Test
    public void testUriEncodeReserved() {
        Assert.assertEquals((Object)"%21%2A%27%28%29%3B%3A%40%26%3D%2B%24%2C%2F%3F%23%5B%5D", (Object)FishEyeURLEncoder.uriEncode((String)"!*'();:@&=+$,/?#[]"));
    }

    @Test
    public void testLazyPathEncodeUnreserved() {
        Assert.assertEquals((Object)this.unreservedCharacters, (Object)FishEyeURLEncoder.pathEncode((String)this.unreservedCharacters));
    }

    @Test
    public void testLazyPathEncodeReserved() {
        Assert.assertEquals((Object)"%21%2A%27%28%29%3B%3A%40%26%3D%2B%24%2C/%3F%23%5B%5D", (Object)FishEyeURLEncoder.pathEncode((String)"!*'();:@&=+$,/?#[]"));
    }
}

