/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.themer;

import com.cenqua.fisheye.web.themer.TableSorterTag;
import java.io.IOException;
import java.io.StringWriter;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.JspTag;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TableSorterTagTest {
    StringWriter stringWriter;

    @Before
    public void setUp() throws Exception {
        this.stringWriter = new StringWriter();
    }

    @Test
    public void testColumnLinkEscapesUrl() throws Exception {
        TableSorterTag tableSorterTag = this.createTableSorterTag("\"></a><script>alert('unsafe!');</script><a href=\"", "sort", "sortValue");
        TableSorterTag.ColumnLink columnLink = this.createColumnLink(tableSorterTag, "columnName");
        columnLink.doTag();
        MatcherAssert.assertThat((Object)this.stringWriter.toString(), (Matcher)Matchers.is((Object)"<a href=\"&quot;&gt;&lt;/a&gt;&lt;script&gt;alert('unsafe!');&lt;/script&gt;&lt;a href=&quot;?%5Esort=columnName\"></a>"));
    }

    private TableSorterTag createTableSorterTag(String baseUrl, String sortParam, String sortValue) throws IOException {
        ServletRequest request = (ServletRequest)Mockito.mock(ServletRequest.class);
        Mockito.when((Object)request.getParameter("^" + sortParam)).thenReturn((Object)sortValue);
        TableSorterTag tableSorter = new TableSorterTag();
        tableSorter.setBaseUrl(baseUrl);
        tableSorter.setSortParam(sortParam);
        PageContext pageContext = (PageContext)Mockito.mock(PageContext.class);
        Mockito.when((Object)pageContext.getRequest()).thenReturn((Object)request);
        tableSorter.setPageContext(pageContext);
        return tableSorter;
    }

    private TableSorterTag.ColumnLink createColumnLink(TableSorterTag parentTag, String columnName) throws IOException {
        TableSorterTag.ColumnLink tag = new TableSorterTag.ColumnLink();
        tag.setName(columnName);
        tag.setParent((JspTag)parentTag);
        JspWriter jspWriter = (JspWriter)Mockito.mock(JspWriter.class);
        ((JspWriter)Mockito.doAnswer(invocation -> {
            this.stringWriter.write((String)invocation.getArguments()[0]);
            return null;
        }).when((Object)jspWriter)).write(Mockito.anyString());
        JspContext jspContext = (JspContext)Mockito.mock(JspContext.class);
        Mockito.when((Object)jspContext.getOut()).thenReturn((Object)jspWriter);
        tag.setJspBody((JspFragment)Mockito.mock(JspFragment.class));
        tag.setJspContext(jspContext);
        return tag;
    }
}

