/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tarball;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.web.tarball.StringLengthMatcher;
import com.cenqua.fisheye.web.tarball.TarballAction;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TarballActionTest {
    private Path pathMock;
    private HttpServletRequest requestMock;
    private TarballAction tarballAction;

    @Before
    public void setUp() throws Exception {
        this.pathMock = (Path)Mockito.mock(Path.class);
        this.requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.tarballAction = new TarballAction();
    }

    @Test
    public void testMakeTarballFilenameShortName() throws Exception {
        Mockito.when((Object)this.pathMock.getName()).thenReturn((Object)"someFile.txt");
        Assert.assertThat((String)"short name with no special characters should not be modified", (Object)TarballAction.makeTarballFilename((Path)this.pathMock), (Matcher)CoreMatchers.equalTo((Object)"someFile.txt"));
    }

    @Test
    public void testMakeTarballFilenameNameWithSpecialCharacters() throws Exception {
        Mockito.when((Object)this.pathMock.getName()).thenReturn((Object)"some file created by Piotr \u015awi\u0119cicki \u00a9(2012) \"'<>.txt");
        Assert.assertThat((String)"file name with special characters should be sanitised", (Object)TarballAction.makeTarballFilename((Path)this.pathMock), (Matcher)CoreMatchers.equalTo((Object)"somefilecreatedbyPiotrwicicki2012.txt"));
    }

    @Test
    public void testMakeTarballFilenameLongName() throws Exception {
        String longName = StringUtils.repeat((String)"_123456789", (int)9) + ".extension";
        Assert.assertThat((String)"test data properly set, 100 characters in file name", (Object)longName, StringLengthMatcher.stringOfLength(100));
        Mockito.when((Object)this.pathMock.getName()).thenReturn((Object)longName);
        Assert.assertThat((String)"file name should be returned intact", (Object)TarballAction.makeTarballFilename((Path)this.pathMock), (Matcher)CoreMatchers.equalTo((Object)longName));
    }

    @Test
    public void testMakeTarballFilenameNameTooLong() throws Exception {
        String tooLongName = StringUtils.repeat((String)"_123456789", (int)10) + ".txt";
        Assert.assertThat((String)"test data properly set, 404 characters in file name", (Object)tooLongName, StringLengthMatcher.stringOfLength(104));
        Mockito.when((Object)this.pathMock.getName()).thenReturn((Object)tooLongName);
        Assert.assertThat((String)"file name should be truncated", (Object)TarballAction.makeTarballFilename((Path)this.pathMock), (Matcher)Matchers.allOf(StringLengthMatcher.stringOfLength(100), (Matcher)CoreMatchers.equalTo((Object)tooLongName.substring(0, 100))));
    }

    @Test
    public void testMakeTarballFilenameEmpty() throws Exception {
        Mockito.when((Object)this.pathMock.getName()).thenReturn((Object)"");
        Assert.assertThat((String)"for empty name 'tarball' should be used", (Object)TarballAction.makeTarballFilename((Path)this.pathMock), (Matcher)CoreMatchers.equalTo((Object)"tarball"));
    }
}

