/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.atlassian.crucible.spi.data.UserData;
import com.cenqua.fisheye.web.tags.ToJsonTag;
import java.io.StringWriter;
import java.io.Writer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ToJsonTagTest {
    private ToJsonTag toJsonTag;
    private StringWriter toJsonTagWriter;

    @Before
    public void setUp() throws Exception {
        this.toJsonTagWriter = new StringWriter();
        this.toJsonTag = new ToJsonTag(){

            protected Writer getWriter() {
                return ToJsonTagTest.this.toJsonTagWriter;
            }
        };
    }

    @Test
    public void testDoTag() throws Exception {
        UserData jsonableData = new UserData("ala", "ala ma kota", "foo/alamakota", "http://avatar/alamakota");
        this.toJsonTag.setObjectToSerialize((Object)jsonableData);
        this.toJsonTag.doTag();
        Assert.assertThat((Object)this.toJsonTagWriter.toString(), (Matcher)CoreMatchers.equalTo((Object)"{\"userName\":\"ala\",\"displayName\":\"ala ma kota\",\"avatarUrl\":\"http://avatar/alamakota\",\"url\":\"foo/alamakota\"}"));
    }

    @Test
    public void testDoTagEscapeJson() throws Exception {
        UserData jsonableData = new UserData("ala", "ala \"ma\" kota", "foo/alamakota", "http://avatar/alamakota");
        this.toJsonTag.setObjectToSerialize((Object)jsonableData);
        this.toJsonTag.doTag();
        Assert.assertThat((Object)this.toJsonTagWriter.toString(), (Matcher)CoreMatchers.equalTo((Object)"{\"userName\":\"ala\",\"displayName\":\"ala \\\"ma\\\" kota\",\"avatarUrl\":\"http://avatar/alamakota\",\"url\":\"foo/alamakota\"}"));
    }

    @Test
    public void testDoTagEscape() throws Exception {
        UserData jsonableData = new UserData("ala", "</script><script>alert('miau miau miau alert!')</script>", "foo/alamakota", "http://avatar/alamakota");
        this.toJsonTag.setObjectToSerialize((Object)jsonableData);
        this.toJsonTag.doTag();
        Assert.assertThat((Object)this.toJsonTagWriter.toString(), (Matcher)CoreMatchers.equalTo((Object)"{\"userName\":\"ala\",\"displayName\":\"\\u003c/script\\u003e\\u003cscript\\u003ealert('miau miau miau alert!')\\u003c/script\\u003e\",\"avatarUrl\":\"http://avatar/alamakota\",\"url\":\"foo/alamakota\"}"));
    }
}

