/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.web.tags.RelativePathTag;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RelativePathTagTest {
    private RelativePathTag relativePathTag;

    @Before
    public void setUp() throws Exception {
        this.relativePathTag = new RelativePathTag();
    }

    @After
    public void tearDown() throws Exception {
        this.relativePathTag = null;
    }

    @Test
    public void testRootLevelPath() throws Exception {
        Path parent = Path.ROOT;
        Path path = new Path((CharSequence)"src/java/main");
        this.relativePathTag.setPath(path);
        this.relativePathTag.setPrefix(parent);
        Assert.assertEquals((String)"Root Level parent should produce a / prefix", (Object)"/src/java/main", (Object)this.relativePathTag.relativePathAsString());
    }

    @Test
    public void testNullParentPath() throws Exception {
        Path path = new Path((CharSequence)"src/java/main");
        this.relativePathTag.setPath(path);
        this.relativePathTag.setPrefix(null);
        Assert.assertEquals((String)"null parent should produce a / prefix", (Object)"/src/java/main", (Object)this.relativePathTag.relativePathAsString());
    }

    @Test
    public void testRelativePath() throws Exception {
        Path parent = new Path((CharSequence)"src/java");
        Path path = new Path((CharSequence)"src/java/main/com/atlassian");
        this.relativePathTag.setPath(path);
        this.relativePathTag.setPrefix(parent);
        Assert.assertEquals((String)"path should be relative with a ./ prefix", (Object)"./main/com/atlassian", (Object)this.relativePathTag.relativePathAsString());
    }

    @Test
    public void testUnrelatedPaths() throws Exception {
        Path parent = new Path((CharSequence)"docs/release");
        Path path = new Path((CharSequence)"src/java/main/com/atlassian");
        this.relativePathTag.setPath(path);
        this.relativePathTag.setPrefix(parent);
        Assert.assertEquals((String)"unrelated path should return a ../ prefixed path", (Object)"../../src/java/main/com/atlassian", (Object)this.relativePathTag.relativePathAsString());
    }
}

