/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.sql.SQLException;
import java.util.List;
import junit.framework.TestCase;
import org.hibernate.InstantiationException;

public class ExpressionUtilTest
extends TestCase {
    public void testExtractThrowableMessagesFromNestedException() {
        Class<Object> clazz = Object.class;
        Exception e1 = null;
        InstantiationException e2 = new InstantiationException("this exception ", clazz, e1);
        InstantiationException e3 = new InstantiationException("foo ", clazz, (Exception)e2);
        List msgs = ExpressionUtil.extractThrowableMessages((Throwable)e3);
        ExpressionUtilTest.assertEquals((int)2, (int)msgs.size());
        System.out.println(msgs);
        ExpressionUtilTest.assertEquals((String)"foo java.lang.Object", (String)((String)msgs.get(0)));
        ExpressionUtilTest.assertEquals((String)"this exception java.lang.Object", (String)((String)msgs.get(1)));
    }

    public void testExtractThrowableMessagesFromException() {
        String expectedMessage = "this exception";
        Exception e = new Exception(expectedMessage);
        List msgs = ExpressionUtil.extractThrowableMessages((Throwable)e);
        ExpressionUtilTest.assertEquals((int)1, (int)msgs.size());
        ExpressionUtilTest.assertEquals((String)expectedMessage, (String)((String)msgs.get(0)));
    }

    public void testExtractThrowableMessagesromSQLException() {
        String reason = "SQL Exception";
        String reason1 = "SQL Exception2";
        SQLException e = new SQLException("SQL Exception", new SQLException("SQL Exception2"));
        String reason2 = "SQL Exception 3";
        String reason3 = "Runtime Exception";
        e.setNextException(new SQLException("SQL Exception 3", new RuntimeException("Runtime Exception")));
        List msgs = ExpressionUtil.extractThrowableMessages((Throwable)e);
        ExpressionUtilTest.assertEquals((int)4, (int)msgs.size());
        ExpressionUtilTest.assertEquals((String)"SQL Exception", (String)((String)msgs.get(0)));
        ExpressionUtilTest.assertEquals((String)"SQL Exception2", (String)((String)msgs.get(1)));
        ExpressionUtilTest.assertEquals((String)"SQL Exception 3", (String)((String)msgs.get(2)));
        ExpressionUtilTest.assertEquals((String)"Runtime Exception", (String)((String)msgs.get(3)));
    }

    public void testEscapeHtmlIdOrName() {
        ExpressionUtilTest.assertEquals((String)"ZZ", (String)ExpressionUtil.escapeHtmlIdOrName((CharSequence)"Z"));
        ExpressionUtilTest.assertEquals((String)"Z1234", (String)ExpressionUtil.escapeHtmlIdOrName((CharSequence)"1234"));
        ExpressionUtilTest.assertEquals((String)"ZZ1234", (String)ExpressionUtil.escapeHtmlIdOrName((CharSequence)"Z1234"));
        ExpressionUtilTest.assertEquals((String)"MAINZ003aARZ005carexerZ003a20081107142904", (String)ExpressionUtil.escapeHtmlIdOrName((CharSequence)"MAIN:AR\\arexer:20081107142904"));
    }

    public void testEscapeFromJavascript() {
        ExpressionUtilTest.assertEquals(null, (String)ExpressionUtil.escapeForJquery(null));
    }
}

