/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.cenqua.fisheye.web.tags.AsJavascriptStringTag;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class AsJavascriptStringTagTest
extends TestCase {
    public void testEscaping() throws Exception {
        this.checkEscape("some plain text", "some plain text");
        this.checkEscape("line1\nline2", "line1|nline2");
        this.checkEscape("line1\rline2", "line1|rline2");
        this.checkEscape("line1\u2028line2", "line1|u2028line2");
        this.checkEscape("line1\u2029line2", "line1|u2029line2");
        this.checkEscape("line1\r\nline2", "line1|r|nline2");
        this.checkEscape("a raw | slash", "a raw || slash");
        this.checkEscape("two || slashes", "two |||| slashes");
        this.checkEscape("a double \" quote", "a double |\" quote");
        this.checkEscape("a single ' quote", "a single ' quote");
        this.checkEscape("some nonprintable ascii \u0000 nul \u0007 bel \u001b esc \u007f del \u0085 thingie", "some nonprintable ascii |u0000 nul |u0007 bel |u001b esc |u007f del |u0085 thingie");
        this.checkEscape("some printable ascii !%*+{}~", "some printable ascii !%*+{}~");
        this.checkEscape("some unicode: armenian \u0531 cherokee \u13a0", "some unicode: armenian |u0531 cherokee |u13a0");
        this.checkEscape("Actually, I checked. This is only a concern if you are using </script> and document.write() in an inline script.\n\nHowever, we shouldn't be using document.write() in our Javascript at all! We might need to let this one slide though, otherwise we'll spend weeks rewriting TinyMCE. :(", "Actually, I checked. This is only a concern if you are using |u003c/script|u003e and document.write() in an inline script.\\n\\nHowever, we shouldn't be using document.write() in our Javascript at all! We might need to let this one slide though, otherwise we'll spend weeks rewriting TinyMCE. :(");
    }

    public void testAllAngleBracketsEscaped() throws Exception {
        this.checkEscape("<script></script>", "|u003cscript|u003e|u003c/script|u003e");
        this.checkEscape("<fake></fake>", "|u003cfake|u003e|u003c/fake|u003e");
        this.checkEscape("<", "|u003c");
        this.checkEscape(">", "|u003e");
    }

    public void testSomeHtmlEscape() throws Exception {
        Assert.assertThat((Object)AsJavascriptStringTag.escapeString((String)"<"), (Matcher)CoreMatchers.equalTo((Object)"\\u003c"));
        Assert.assertThat((Object)AsJavascriptStringTag.escapeString((String)">"), (Matcher)CoreMatchers.equalTo((Object)"\\u003e"));
        Assert.assertThat((Object)AsJavascriptStringTag.escapeString((String)"&"), (Matcher)CoreMatchers.equalTo((Object)"&"));
    }

    private void checkEscape(String input, String expectedOutput) throws IOException {
        input = input.replace('|', '\\');
        expectedOutput = expectedOutput.replace('|', '\\');
        StringWriter buf = new StringWriter();
        AsJavascriptStringTag.escape((Reader)new StringReader(input), (Writer)buf);
        AsJavascriptStringTagTest.assertEquals((String)expectedOutput, (String)buf.toString());
    }
}

