/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.web.tags.AbstractRegionListTag;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public final class AbstractRegionListTagTest {
    private AbstractRegionListTag mFormatter = new MyAbstractRegionListTag();

    @Before
    public void setUp() throws Exception {
        this.mFormatter.setEol("\n");
        this.mFormatter.setEscapeHTML(false);
        this.mFormatter.setSpace(" ");
    }

    @Test
    public void testNewlines() throws Exception {
        this.assertPreformat("abc\ndef", "abc\ndef");
        this.assertPreformat("abc\ndef", "abc\rdef");
        this.assertPreformat("abc\ndef", "abc\r\ndef");
    }

    @Test
    public void testTabStops() throws Exception {
        this.assertPreformat("        ", "\t");
        this.assertPreformat("        abc", "\tabc");
        this.assertPreformat("0123456 asd", "0123456\tasd");
        this.assertPreformat("012345  asd", "012345\tasd");
    }

    private void assertPreformat(String expected, String input) throws Exception {
        StringWriter buf = new StringWriter();
        this.mFormatter.resetLine();
        this.mFormatter.format((Writer)buf, (CharSequence)input);
        String actual = buf.toString();
        Assert.assertEquals((String)expected, (String)actual);
    }

    private static class MyAbstractRegionListTag
    extends AbstractRegionListTag {
        private MyAbstractRegionListTag() {
        }

        protected String getSpanClass(Region region) {
            return null;
        }
    }
}

