/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.cenqua.fisheye.web.tags.AbbreviatePathTag;
import javax.servlet.jsp.JspException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbbreviatePathTagTest {
    private AbbreviatePathTag abbreviatePathTag;

    @Before
    public void setUp() throws Exception {
        this.abbreviatePathTag = new AbbreviatePathTag();
    }

    @Test
    public void testSimplePath() throws JspException {
        this.abbreviatePathTag.setPathString("src/test/main/this/that");
        Assert.assertEquals((Object)"<span>src/</span><span>test/</span><span>main</span><span>/this</span><span>/that</span>", (Object)this.abbreviatePathTag.abbreviatePathFormatted());
        this.abbreviatePathTag.setPathString("/src/test/main/this/that");
        Assert.assertEquals((Object)"<span>/src/</span><span>test/</span><span>main</span><span>/this</span><span>/that</span>", (Object)this.abbreviatePathTag.abbreviatePathFormatted());
        this.abbreviatePathTag.setPathString("/src/test/main/this/that/");
        Assert.assertEquals((Object)"<span>/src/</span><span>test/</span><span>main</span><span>/this</span><span>/that/</span>", (Object)this.abbreviatePathTag.abbreviatePathFormatted());
    }

    @Test
    public void testAcrossOneSpan() throws JspException {
        this.abbreviatePathTag.setPathString("sr<span class=\"trouble\">c/test/main/t</span>his/that");
        Assert.assertEquals((Object)"<span>sr<span class=\"trouble\">c/</span></span><span><span class=\"trouble\">test/</span></span><span><span class=\"trouble\">main</span></span><span><span class=\"trouble\">/t</span>his</span><span>/that</span>", (Object)this.abbreviatePathTag.abbreviatePathFormatted());
    }

    @Test
    public void testAcrossMultipleTags() throws JspException {
        this.abbreviatePathTag.setPathString("sr<span class=\"trouble\">c/test/m<span class=\"makeItDouble\">ain/t</span>hi</span><em>s/th</em>at");
        Assert.assertEquals((Object)"<span>sr<span class=\"trouble\">c/</span></span><span><span class=\"trouble\">test/</span></span><span><span class=\"trouble\">m<span class=\"makeItDouble\">ain</span></span></span><span><span class=\"trouble\"><span class=\"makeItDouble\">/t</span>hi</span><em>s</em></span><span><em>/th</em>at</span>", (Object)this.abbreviatePathTag.abbreviatePathFormatted());
    }
}

