/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.security;

import com.cenqua.fisheye.web.security.BasicRfc2617Authenticator;
import junit.framework.TestCase;
import org.apache.commons.codec.binary.Base64;

public class BasicRfc2617AuthenticatorTest
extends TestCase {
    public void testAuthRequired() {
        BasicRfc2617AuthenticatorTest.assertFalse((boolean)new BasicRfc2617Authenticator((String)null).containsUsernamePassword());
        BasicRfc2617AuthenticatorTest.assertFalse((boolean)new BasicRfc2617Authenticator("").containsUsernamePassword());
        BasicRfc2617AuthenticatorTest.assertFalse((boolean)new BasicRfc2617Authenticator("blah").containsUsernamePassword());
        BasicRfc2617AuthenticatorTest.assertFalse((boolean)new BasicRfc2617Authenticator("Basic ___").containsUsernamePassword());
    }

    public void testInvalidEncodedString() {
        BasicRfc2617AuthenticatorTest.assertFalse((boolean)new BasicRfc2617Authenticator("Basic " + this.asBase64("doesNotContailColon")).containsUsernamePassword());
        BasicRfc2617AuthenticatorTest.assertFalse((boolean)new BasicRfc2617Authenticator("Basic " + this.asBase64("small")).containsUsernamePassword());
        BasicRfc2617AuthenticatorTest.assertFalse((boolean)new BasicRfc2617Authenticator("Basic " + this.asBase64("")).containsUsernamePassword());
        BasicRfc2617AuthenticatorTest.assertFalse((boolean)new BasicRfc2617Authenticator("Basic ").containsUsernamePassword());
        BasicRfc2617AuthenticatorTest.assertFalse((boolean)new BasicRfc2617Authenticator("Basic").containsUsernamePassword());
    }

    public void testCorrectPassword() {
        BasicRfc2617Authenticator auth = new BasicRfc2617Authenticator("Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        BasicRfc2617AuthenticatorTest.assertTrue((boolean)auth.containsUsernamePassword());
        BasicRfc2617AuthenticatorTest.assertEquals((String)"Aladdin", (String)auth.getUsername());
        BasicRfc2617AuthenticatorTest.assertEquals((String)"open sesame", (String)auth.getPassword());
        auth = new BasicRfc2617Authenticator("Basic " + this.asBase64("username:password"));
        BasicRfc2617AuthenticatorTest.assertTrue((boolean)auth.containsUsernamePassword());
        BasicRfc2617AuthenticatorTest.assertEquals((String)"username", (String)auth.getUsername());
        BasicRfc2617AuthenticatorTest.assertEquals((String)"password", (String)auth.getPassword());
    }

    private String asBase64(String in) {
        return new String(Base64.encodeBase64((byte[])in.getBytes()));
    }
}

