/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.rdiff;

import com.cenqua.fisheye.DiffTestUtils;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.CvsTestUtil;
import com.cenqua.fisheye.cvsrep.cache.CvsCache;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.cenqua.fisheye.web.rdiff.PatchPrinter;
import java.io.File;
import junit.framework.TestCase;

public class PatchPrinterTest
extends TestCase {
    private CvsCache mRep;

    protected void setUp() throws Exception {
        File f = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/patchprinter/repos");
        this.mRep = CvsTestUtil.makeRevisionCache(f);
    }

    public void testPatches() throws Exception {
        this.assertDiff((RevisionCache)this.mRep, "test/testfiles/patchprinter/a-1.1-1.2-diff.txt", 25, "a.txt", "1.1", "1.2");
        this.assertDiff((RevisionCache)this.mRep, "test/testfiles/patchprinter/a-1.2-1.3-diff.txt", 9, "a.txt", "1.2", "1.3");
        this.assertDiff((RevisionCache)this.mRep, "test/testfiles/patchprinter/b-1.1-1.2-diff.txt", 0, "b.txt", "1.1", "1.2");
        this.assertDiff((RevisionCache)this.mRep, "test/testfiles/patchprinter/b-1.2-1.3-diff.txt", 0, "b.txt", "1.2", "1.3");
        this.assertDiff((RevisionCache)this.mRep, "test/testfiles/patchprinter/b-1.2-1.4-diff.txt", 0, "b.txt", "1.2", "1.4");
        PatchPrinter.PatchOptions opts = new PatchPrinter.PatchOptions();
        opts.absentAsEmpty = true;
        DiffTestUtils.assertDiff((RevisionCache)this.mRep, "test/testfiles/patchprinter/b-1.1-1.2-diff-N.txt", 30, opts, "b.txt", "1.1", "1.2");
        DiffTestUtils.assertDiff((RevisionCache)this.mRep, "test/testfiles/patchprinter/b-1.2-1.3-diff-N.txt", 5, opts, "b.txt", "1.2", "1.3");
        this.assertDiff((RevisionCache)this.mRep, "test/testfiles/patchprinter/c-1.1-1.2-diff.txt", 0, "c.txt", "1.1", "1.2");
    }

    public void testBinaryPatches() throws Exception {
        this.assertDiff((RevisionCache)this.mRep, "test/testfiles/patchprinter/bin-1.1-1.1-diff.txt", 0, "bin.zip", "1.1", "1.1");
        this.assertDiff((RevisionCache)this.mRep, "test/testfiles/patchprinter/bin-1.1-1.2-diff.txt", 1, "bin.zip", "1.1", "1.2");
    }

    private void assertDiff(RevisionCache cache, String expected, int expectedSignificantLines, String path, String rs1, String rs2) throws Exception {
        DiffTestUtils.assertDiff(cache, expected, expectedSignificantLines, null, path, rs1, rs2);
    }
}

