/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.profile.actions;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.model.CommitterUserMapping;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.profile.actions.EditAuthorMappingAction;
import com.google.common.collect.ImmutableMultimap;
import javax.servlet.http.HttpServletRequest;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class EditAuthorMappingActionTest {
    private EditAuthorMappingAction editAuthorMappingAction;
    private RootConfig oldRootConfig;
    private RootConfig rootConfigMock;
    private UserManager userManagerMock;
    private UserLogin currentUserLoginMock;
    private CommitterUserMappingManager committerUserMappingManagerMock;
    private FecruUser userMock;

    @Before
    public void setUp() {
        this.editAuthorMappingAction = new EditAuthorMappingAction();
        this.oldRootConfig = AppConfig.getsConfig();
        this.rootConfigMock = (RootConfig)Mockito.mock(RootConfig.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.rootConfigMock.getConfig().getSecurity().getAllowUserMapping()).thenReturn((Object)true);
        AppConfig.resetConfig((RootConfig)this.rootConfigMock);
        this.editAuthorMappingAction.userManager = this.userManagerMock = (UserManager)Mockito.mock(UserManager.class);
        this.currentUserLoginMock = (UserLogin)Mockito.mock(UserLogin.class);
        Mockito.when((Object)this.currentUserLoginMock.getUsername()).thenReturn((Object)"maciek");
        Mockito.when((Object)this.userManagerMock.getCurrentUser((HttpServletRequest)Matchers.any(HttpServletRequest.class))).thenReturn((Object)this.currentUserLoginMock);
        this.userMock = (FecruUser)Mockito.mock(FecruUser.class);
        Mockito.when((Object)this.userManagerMock.getLicensedUser("maciek")).thenReturn((Object)this.userMock);
        this.editAuthorMappingAction.manager = this.committerUserMappingManagerMock = (CommitterUserMappingManager)Mockito.mock(CommitterUserMappingManager.class);
        Mockito.when((Object)this.committerUserMappingManagerMock.getExplicitCommittersForUser("maciek")).thenReturn((Object)new ImmutableMultimap.Builder().putAll((Object)"repo1", (Object[])new String[]{"commiter1a", "commiter1b"}).build());
    }

    @After
    public void tearDown() {
        AppConfig.resetConfig((RootConfig)this.oldRootConfig);
    }

    @Test
    public void testEditMappingNotAllowed() {
        Mockito.when((Object)this.rootConfigMock.getConfig().getSecurity().getAllowUserMapping()).thenReturn((Object)false);
        Assert.assertThat((Object)this.editAuthorMappingAction.editMapping(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"error"));
    }

    @Test
    public void testEditMappingNoCurrentUser() {
        Mockito.when((Object)this.userManagerMock.getCurrentUser((HttpServletRequest)Matchers.any(HttpServletRequest.class))).thenReturn(null);
        Assert.assertThat((Object)this.editAuthorMappingAction.editMapping(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"error"));
        Assert.assertThat((Object)this.editAuthorMappingAction.getActionErrors(), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"User not found"}));
    }

    @Test
    public void testEditMappingExplicitMappingExistsForAnotherActiveUserOverrideRequired() {
        this.editAuthorMappingAction.setRep("repo2");
        this.editAuthorMappingAction.setCommitter("commiter1a");
        this.editAuthorMappingAction.setConfirmOverride(false);
        FecruUser presupposedActive = (FecruUser)Mockito.mock(FecruUser.class);
        Mockito.when((Object)presupposedActive.getDisplayName()).thenReturn((Object)"zosiasamosia");
        CommitterUserMapping oldCommitterUserMapping = new CommitterUserMapping("zosiasamosia", "repo2", "commiter1a");
        Mockito.when((Object)this.committerUserMappingManagerMock.findByRepositoryAndCommitter("repo2", "commiter1a")).thenReturn((Object)oldCommitterUserMapping);
        Mockito.when((Object)this.committerUserMappingManagerMock.getUserForCommitter("repo2", "commiter1a")).thenReturn((Object)presupposedActive);
        Assert.assertThat((Object)this.editAuthorMappingAction.hasConfirmed(), (Matcher)org.hamcrest.Matchers.equalTo((Object)false));
        Assert.assertThat((Object)this.editAuthorMappingAction.editMapping(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"input"));
        Assert.assertThat((Object)this.editAuthorMappingAction.hasConfirmed(), (Matcher)org.hamcrest.Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.editAuthorMappingAction.getActionErrors(), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"Mapping already belongs to zosiasamosia. Click 'Add mapping' to override."}));
    }

    @Test
    public void testEditMappingExplicitMappingExistsForAnotherActiveUserOverrideDone() {
        this.editAuthorMappingAction.setRep("repo2");
        this.editAuthorMappingAction.setCommitter("commiter1a");
        this.editAuthorMappingAction.setConfirmOverride(true);
        FecruUser presupposedActive = (FecruUser)Mockito.mock(FecruUser.class);
        Mockito.when((Object)presupposedActive.getDisplayName()).thenReturn((Object)"zosiasamosia");
        CommitterUserMapping oldCommitterUserMapping = new CommitterUserMapping("zosiasamosia", "repo2", "commiter1a");
        Mockito.when((Object)this.committerUserMappingManagerMock.findByRepositoryAndCommitter("repo2", "commiter1a")).thenReturn((Object)oldCommitterUserMapping);
        Mockito.when((Object)this.committerUserMappingManagerMock.getUserForCommitter("repo2", "commiter1a")).thenReturn((Object)presupposedActive);
        Assert.assertThat((Object)this.editAuthorMappingAction.editMapping(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"success"));
        ((CommitterUserMappingManager)Mockito.verify((Object)this.committerUserMappingManagerMock, (VerificationMode)Mockito.times((int)1))).updateMapping(oldCommitterUserMapping, new CommitterUserMapping("maciek", "repo2", "commiter1a"));
    }

    @Test
    public void testEditMappingExplicitMappingExistsForAnotherInactiveUser() {
        this.editAuthorMappingAction.setRep("repo2");
        this.editAuthorMappingAction.setCommitter("commiter1a");
        this.editAuthorMappingAction.setConfirmOverride(false);
        Object presupposedActive = null;
        CommitterUserMapping oldCommitterUserMapping = new CommitterUserMapping("zosiasamosia", "repo2", "commiter1a");
        Mockito.when((Object)this.committerUserMappingManagerMock.findByRepositoryAndCommitter("repo2", "commiter1a")).thenReturn((Object)oldCommitterUserMapping);
        Mockito.when((Object)this.committerUserMappingManagerMock.getUserForCommitter("repo2", "commiter1a")).thenReturn(presupposedActive);
        Assert.assertThat((Object)this.editAuthorMappingAction.editMapping(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"success"));
        ((CommitterUserMappingManager)Mockito.verify((Object)this.committerUserMappingManagerMock, (VerificationMode)Mockito.times((int)1))).updateMapping(oldCommitterUserMapping, new CommitterUserMapping("maciek", "repo2", "commiter1a"));
    }

    @Test
    public void testEditMappingNoOtherExplicitMappingExists() {
        this.editAuthorMappingAction.setRep("repo2");
        this.editAuthorMappingAction.setCommitter("commiter1a");
        Mockito.when((Object)this.committerUserMappingManagerMock.findByRepositoryAndCommitter("repo2", "commiter1a")).thenReturn(null);
        Assert.assertThat((Object)this.editAuthorMappingAction.editMapping(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"success"));
        ((CommitterUserMappingManager)Mockito.verify((Object)this.committerUserMappingManagerMock, (VerificationMode)Mockito.times((int)1))).addMapping("maciek", "repo2", "commiter1a");
    }
}

