/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.profile.actions;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.filters.DummyHttpServletRequest;
import com.cenqua.fisheye.web.profile.actions.ChangePasswordAction;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class ChangePasswordActionTest {
    private ChangePasswordAction action;
    private FecruUser fred = new FecruUser("fred");
    private UserManager mockUserManager;

    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.getSanity1Repos();
    }

    @Before
    public void setUp() throws Exception {
        this.mockUserManager = (UserManager)Mockito.mock(UserManager.class);
        Mockito.when((Object)this.mockUserManager.getLicensedUser("fred")).thenReturn((Object)this.fred);
        DummyHttpServletRequest req = new DummyHttpServletRequest();
        Mockito.when((Object)this.mockUserManager.getCurrentUser((HttpServletRequest)req)).thenReturn((Object)new UserLogin(this.fred, null, null));
        this.action = new ChangePasswordAction(this.mockUserManager);
        this.action.setServletRequest((HttpServletRequest)req);
    }

    @After
    public void tearDown() throws Exception {
        this.action = null;
        this.mockUserManager = null;
        this.fred = null;
    }

    @Test
    public void testOK() throws DbException, LicensePolicyException {
        this.action.setCurrentPassword("foobar");
        this.action.setNewPassword("barfoo");
        this.action.setConfirmNewPassword("barfoo");
        Mockito.when((Object)this.mockUserManager.isValidPassword("fred", "foobar")).thenReturn((Object)Boolean.TRUE);
        Assert.assertEquals((String)"success", (String)this.action.execute());
        ((UserManager)Mockito.verify((Object)this.mockUserManager)).changePassword(this.fred.getUsername(), "barfoo");
    }

    @Test
    public void testWrongPassword() {
        this.action.setCurrentPassword("foobarz");
        this.action.setNewPassword("barfoo");
        this.action.setConfirmNewPassword("barfoo");
        Assert.assertEquals((String)"input", (String)this.action.execute());
        Collection errors = (Collection)this.action.getFieldErrors().get("currentPassword");
        Assert.assertTrue((boolean)errors.contains("Incorrect password"));
    }
}

