/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.paging;

import com.cenqua.fisheye.web.paging.PaginationItem;
import com.cenqua.fisheye.web.paging.Separator;
import com.cenqua.fisheye.web.paging.TotalCountAwarePagingCalculator;
import java.util.List;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class TotalCountAwarePagingCalculatorTest
extends TestCase {
    public void testPagingLotsOfItems() {
        int numItems = 204;
        int numPerPage = 7;
        TotalCountAwarePagingCalculator pages = new TotalCountAwarePagingCalculator(1, numItems, numPerPage);
        TotalCountAwarePagingCalculatorTest.assertEquals((int)numPerPage, (int)pages.getNumPerPage());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)1, (int)pages.getPage());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)0, (int)pages.getCurrentPageStart());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)numPerPage, (int)pages.getCurrentPageEnd());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)30, (int)pages.getNumPages());
        TotalCountAwarePagingCalculatorTest.assertFalse((boolean)pages.isLastPage());
        TotalCountAwarePagingCalculatorTest.assertFalse((boolean)pages.isSinglePage());
        TotalCountAwarePagingCalculatorTest.assertTrue((boolean)pages.isFirstPage());
        int currentPage = 11;
        pages = new TotalCountAwarePagingCalculator(currentPage, numItems, numPerPage);
        TotalCountAwarePagingCalculatorTest.assertEquals((int)currentPage, (int)pages.getPage());
        TotalCountAwarePagingCalculatorTest.assertFalse((boolean)pages.isFirstPage());
        TotalCountAwarePagingCalculatorTest.assertFalse((boolean)pages.isLastPage());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)((currentPage - 1) * numPerPage), (int)pages.getCurrentPageStart());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)(currentPage * numPerPage), (int)pages.getCurrentPageEnd());
        currentPage = 30;
        pages = new TotalCountAwarePagingCalculator(currentPage, numItems, numPerPage);
        TotalCountAwarePagingCalculatorTest.assertTrue((boolean)pages.isLastPage());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)currentPage, (int)pages.getPage());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)(numItems - 1), (int)pages.getCurrentPageStart());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)numItems, (int)pages.getCurrentPageEnd());
        pages = new TotalCountAwarePagingCalculator(1, numItems, 204);
        TotalCountAwarePagingCalculatorTest.assertTrue((boolean)pages.isFirstPage());
        TotalCountAwarePagingCalculatorTest.assertTrue((boolean)pages.isLastPage());
        TotalCountAwarePagingCalculatorTest.assertTrue((boolean)pages.isSinglePage());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)0, (int)pages.getCurrentPageStart());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)numItems, (int)pages.getCurrentPageEnd());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)1, (int)pages.getNumPages());
        pages = new TotalCountAwarePagingCalculator(1, numItems, 203);
        TotalCountAwarePagingCalculatorTest.assertTrue((boolean)pages.isFirstPage());
        TotalCountAwarePagingCalculatorTest.assertFalse((boolean)pages.isLastPage());
        TotalCountAwarePagingCalculatorTest.assertFalse((boolean)pages.isSinglePage());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)0, (int)pages.getCurrentPageStart());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)(numItems - 1), (int)pages.getCurrentPageEnd());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)2, (int)pages.getNumPages());
        pages = new TotalCountAwarePagingCalculator(2, numItems, 203);
        TotalCountAwarePagingCalculatorTest.assertTrue((boolean)pages.isLastPage());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)(numItems - 1), (int)pages.getCurrentPageStart());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)numItems, (int)pages.getCurrentPageEnd());
    }

    public void testPagingNoItems() {
        TotalCountAwarePagingCalculator pages = TotalCountAwarePagingCalculator.getPagingCalculator((int)1, (int)0);
        TotalCountAwarePagingCalculatorTest.assertTrue((boolean)pages.isFirstPage());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)30, (int)pages.getNumPerPage());
        TotalCountAwarePagingCalculatorTest.assertTrue((boolean)pages.isLastPage());
        TotalCountAwarePagingCalculatorTest.assertTrue((boolean)pages.isSinglePage());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)0, (int)pages.getCurrentPageStart());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)0, (int)pages.getCurrentPageEnd());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)0, (int)pages.getNumPages());
    }

    public void testPagingOneItems() {
        TotalCountAwarePagingCalculator pages = TotalCountAwarePagingCalculator.getPagingCalculator((int)1, (int)1);
        TotalCountAwarePagingCalculatorTest.assertTrue((boolean)pages.isFirstPage());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)30, (int)pages.getNumPerPage());
        TotalCountAwarePagingCalculatorTest.assertTrue((boolean)pages.isLastPage());
        TotalCountAwarePagingCalculatorTest.assertTrue((boolean)pages.isSinglePage());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)0, (int)pages.getCurrentPageStart());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)1, (int)pages.getCurrentPageEnd());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)1, (int)pages.getNumPages());
    }

    public void testPagingTooFar() {
        int numItems = 100;
        int numPerPage = 10;
        TotalCountAwarePagingCalculator pages = new TotalCountAwarePagingCalculator(1, numItems, numPerPage);
        TotalCountAwarePagingCalculatorTest.assertEquals((int)(numItems / numPerPage), (int)pages.getNumPages());
        TotalCountAwarePagingCalculatorTest.assertEquals((int)1, (int)pages.getPage());
        pages = new TotalCountAwarePagingCalculator(11, numItems, numPerPage);
        TotalCountAwarePagingCalculatorTest.assertEquals((int)pages.getNumPages(), (int)pages.getPage());
    }

    public void testSmallPagination() {
        List paginationPage1 = TotalCountAwarePagingCalculator.getPagingCalculator((int)1, (int)5, (int)1).generatePagination();
        List paginationPage3 = TotalCountAwarePagingCalculator.getPagingCalculator((int)3, (int)5, (int)1).generatePagination();
        List paginationPage5 = TotalCountAwarePagingCalculator.getPagingCalculator((int)5, (int)5, (int)1).generatePagination();
        Assert.assertThat((Object)paginationPage1, (Matcher)Matchers.contains((Object[])new PaginationItem[]{new PaginationItem(1, true), new PaginationItem(2, false), new PaginationItem(3, false), new PaginationItem(4, false), new PaginationItem(5, false)}));
        Assert.assertThat((Object)paginationPage3, (Matcher)Matchers.contains((Object[])new PaginationItem[]{new PaginationItem(1, false), new PaginationItem(2, false), new PaginationItem(3, true), new PaginationItem(4, false), new PaginationItem(5, false)}));
        Assert.assertThat((Object)paginationPage5, (Matcher)Matchers.contains((Object[])new PaginationItem[]{new PaginationItem(1, false), new PaginationItem(2, false), new PaginationItem(3, false), new PaginationItem(4, false), new PaginationItem(5, true)}));
    }

    public void testAveragePagination() {
        List paginationPage1 = TotalCountAwarePagingCalculator.getPagingCalculator((int)1, (int)12, (int)1).generatePagination();
        List paginationPage3 = TotalCountAwarePagingCalculator.getPagingCalculator((int)3, (int)12, (int)1).generatePagination();
        List paginationPage6 = TotalCountAwarePagingCalculator.getPagingCalculator((int)6, (int)12, (int)1).generatePagination();
        List paginationPage9 = TotalCountAwarePagingCalculator.getPagingCalculator((int)9, (int)12, (int)1).generatePagination();
        List paginationPage12 = TotalCountAwarePagingCalculator.getPagingCalculator((int)12, (int)12, (int)1).generatePagination();
        Assert.assertThat((Object)paginationPage1, (Matcher)Matchers.contains((Object[])new PaginationItem[]{new PaginationItem(1, true), new PaginationItem(2, false), new PaginationItem(3, false), new PaginationItem(4, false), new PaginationItem(5, false), new PaginationItem(6, false), Separator.instance, new PaginationItem(11, false), new PaginationItem(12, false)}));
        Assert.assertThat((Object)paginationPage3, (Matcher)Matchers.contains((Object[])new PaginationItem[]{new PaginationItem(1, false), new PaginationItem(2, false), new PaginationItem(3, true), new PaginationItem(4, false), new PaginationItem(5, false), new PaginationItem(6, false), Separator.instance, new PaginationItem(11, false), new PaginationItem(12, false)}));
        Assert.assertThat((Object)paginationPage6, (Matcher)Matchers.contains((Object[])new PaginationItem[]{new PaginationItem(1, false), new PaginationItem(2, false), new PaginationItem(3, false), new PaginationItem(4, false), new PaginationItem(5, false), new PaginationItem(6, true), new PaginationItem(7, false), new PaginationItem(8, false), new PaginationItem(9, false), new PaginationItem(10, false), new PaginationItem(11, false), new PaginationItem(12, false)}));
        Assert.assertThat((Object)paginationPage9, (Matcher)Matchers.contains((Object[])new PaginationItem[]{new PaginationItem(1, false), new PaginationItem(2, false), Separator.instance, new PaginationItem(7, false), new PaginationItem(8, false), new PaginationItem(9, true), new PaginationItem(10, false), new PaginationItem(11, false), new PaginationItem(12, false)}));
        Assert.assertThat((Object)paginationPage12, (Matcher)Matchers.contains((Object[])new PaginationItem[]{new PaginationItem(1, false), new PaginationItem(2, false), Separator.instance, new PaginationItem(7, false), new PaginationItem(8, false), new PaginationItem(9, false), new PaginationItem(10, false), new PaginationItem(11, false), new PaginationItem(12, true)}));
    }

    public void testHugePagination() {
        List paginationPage1 = TotalCountAwarePagingCalculator.getPagingCalculator((int)1, (int)40, (int)1).generatePagination();
        List paginationPage8 = TotalCountAwarePagingCalculator.getPagingCalculator((int)8, (int)40, (int)1).generatePagination();
        List paginationPage9 = TotalCountAwarePagingCalculator.getPagingCalculator((int)9, (int)40, (int)1).generatePagination();
        List paginationPage31 = TotalCountAwarePagingCalculator.getPagingCalculator((int)31, (int)40, (int)1).generatePagination();
        List paginationPage32 = TotalCountAwarePagingCalculator.getPagingCalculator((int)32, (int)40, (int)1).generatePagination();
        List paginationPage40 = TotalCountAwarePagingCalculator.getPagingCalculator((int)40, (int)40, (int)1).generatePagination();
        Assert.assertThat((Object)paginationPage1, (Matcher)Matchers.contains((Object[])new PaginationItem[]{new PaginationItem(1, true), new PaginationItem(2, false), new PaginationItem(3, false), new PaginationItem(4, false), new PaginationItem(5, false), new PaginationItem(6, false), Separator.instance, new PaginationItem(39, false), new PaginationItem(40, false)}));
        Assert.assertThat((Object)paginationPage8, (Matcher)Matchers.contains((Object[])new PaginationItem[]{new PaginationItem(1, false), new PaginationItem(2, false), new PaginationItem(3, false), new PaginationItem(4, false), new PaginationItem(5, false), new PaginationItem(6, false), new PaginationItem(7, false), new PaginationItem(8, true), new PaginationItem(9, false), new PaginationItem(10, false), new PaginationItem(11, false), Separator.instance, new PaginationItem(39, false), new PaginationItem(40, false)}));
        Assert.assertThat((Object)paginationPage9, (Matcher)Matchers.contains((Object[])new PaginationItem[]{new PaginationItem(1, false), new PaginationItem(2, false), Separator.instance, new PaginationItem(7, false), new PaginationItem(8, false), new PaginationItem(9, true), new PaginationItem(10, false), new PaginationItem(11, false), new PaginationItem(12, false), Separator.instance, new PaginationItem(39, false), new PaginationItem(40, false)}));
        Assert.assertThat((Object)paginationPage31, (Matcher)Matchers.contains((Object[])new PaginationItem[]{new PaginationItem(1, false), new PaginationItem(2, false), Separator.instance, new PaginationItem(29, false), new PaginationItem(30, false), new PaginationItem(31, true), new PaginationItem(32, false), new PaginationItem(33, false), new PaginationItem(34, false), Separator.instance, new PaginationItem(39, false), new PaginationItem(40, false)}));
        Assert.assertThat((Object)paginationPage32, (Matcher)Matchers.contains((Object[])new PaginationItem[]{new PaginationItem(1, false), new PaginationItem(2, false), Separator.instance, new PaginationItem(30, false), new PaginationItem(31, false), new PaginationItem(32, true), new PaginationItem(33, false), new PaginationItem(34, false), new PaginationItem(35, false), new PaginationItem(36, false), new PaginationItem(37, false), new PaginationItem(38, false), new PaginationItem(39, false), new PaginationItem(40, false)}));
        Assert.assertThat((Object)paginationPage40, (Matcher)Matchers.contains((Object[])new PaginationItem[]{new PaginationItem(1, false), new PaginationItem(2, false), Separator.instance, new PaginationItem(35, false), new PaginationItem(36, false), new PaginationItem(37, false), new PaginationItem(38, false), new PaginationItem(39, false), new PaginationItem(40, true)}));
    }
}

