/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.paging;

import com.atlassian.fecru.page.PageRequest;
import com.cenqua.fisheye.web.paging.PreviousNextPagingCalculator;
import javax.servlet.http.HttpServletRequest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class PreviousNextPagingCalculatorTest {
    @Test
    public void testPaginationIsAlwaysEmpty() throws Exception {
        Assert.assertThat((Object)this.newPreviousNextPagingCalculator(1).generatePagination(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)this.newPreviousNextPagingCalculator(2).generatePagination(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)this.newPreviousNextPagingCalculator(3).generatePagination(), (Matcher)Matchers.empty());
    }

    @Test
    public void testIsFirstPage() throws Exception {
        Assert.assertTrue((boolean)this.newPreviousNextPagingCalculator(1).isFirstPage());
        Assert.assertFalse((boolean)this.newPreviousNextPagingCalculator(2).isFirstPage());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPageBelowFirstPage() throws Exception {
        this.newPreviousNextPagingCalculator(0);
    }

    @Test
    public void testIsLastPageSet() throws Exception {
        PreviousNextPagingCalculator pagingCalculator = this.newPreviousNextPagingCalculator(1);
        pagingCalculator.setLastPage(Boolean.valueOf(false));
        Assert.assertFalse((boolean)pagingCalculator.isLastPage());
        pagingCalculator.setLastPage(Boolean.valueOf(true));
        Assert.assertTrue((boolean)pagingCalculator.isLastPage());
    }

    @Test(expected=IllegalStateException.class)
    public void testIsLastPageNotSet() throws Exception {
        this.newPreviousNextPagingCalculator(1).isLastPage();
    }

    @Test
    public void testIsSinglePage() throws Exception {
        PreviousNextPagingCalculator pagingCalculatorPage1 = this.newPreviousNextPagingCalculator(1);
        pagingCalculatorPage1.setLastPage(Boolean.valueOf(false));
        Assert.assertFalse((boolean)pagingCalculatorPage1.isSinglePage());
        pagingCalculatorPage1.setLastPage(Boolean.valueOf(true));
        Assert.assertTrue((boolean)pagingCalculatorPage1.isSinglePage());
    }

    @Test
    public void testIsNotSinglePage() throws Exception {
        PreviousNextPagingCalculator pagingCalculatorPage2 = this.newPreviousNextPagingCalculator(2);
        pagingCalculatorPage2.setLastPage(Boolean.valueOf(false));
        Assert.assertFalse((boolean)pagingCalculatorPage2.isSinglePage());
        pagingCalculatorPage2.setLastPage(Boolean.valueOf(true));
        Assert.assertFalse((boolean)pagingCalculatorPage2.isSinglePage());
    }

    @Test(expected=IllegalStateException.class)
    public void testIsSinglePageWhenIsLastPageNotSet() throws Exception {
        this.newPreviousNextPagingCalculator(1).isSinglePage();
    }

    @Test
    public void testGetPage() throws Exception {
        for (int page = 1; page < 4; ++page) {
            Assert.assertEquals((long)page, (long)this.newPreviousNextPagingCalculator(page).getPage());
        }
    }

    @Test
    public void testCreatePageRequest() throws Exception {
        for (int page = 1; page < 4; ++page) {
            Assert.assertEquals((Object)PageRequest.create((Integer)((page - 1) * 30), (Integer)30), (Object)this.newPreviousNextPagingCalculator(page).createPageRequest());
        }
    }

    @Test
    public void testGetCurrentPageStart() throws Exception {
        for (int page = 1; page < 4; ++page) {
            Assert.assertEquals((long)((page - 1) * 30), (long)this.newPreviousNextPagingCalculator(page).getCurrentPageStart());
        }
    }

    @Test
    public void testGetCurrentPageEnd() throws Exception {
        for (int page = 1; page < 4; ++page) {
            Assert.assertEquals((long)(page * 30), (long)this.newPreviousNextPagingCalculator(page).getCurrentPageEnd());
        }
    }

    private PreviousNextPagingCalculator newPreviousNextPagingCalculator(Integer page) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("page", page.toString());
        return new PreviousNextPagingCalculator((HttpServletRequest)request);
    }
}

