/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.mime;

import com.cenqua.fisheye.web.mime.ContentDispositionHeaderGuesser;
import com.cenqua.fisheye.web.mime.DownloadPolicy;
import com.cenqua.fisheye.web.mime.DownloadPolicyProvider;
import com.cenqua.fisheye.web.mime.HostileExtensionDetector;
import com.cenqua.fisheye.web.mime.UserAgentUtil;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ContentDispositionHeaderGuesserTest {
    private static final ImmutableSet<UserAgentUtil.BrowserMajorVersion> GOOD_BROWSERS = ImmutableSet.of((Object)UserAgentUtil.BrowserMajorVersion.FIREFOX4, (Object)UserAgentUtil.BrowserMajorVersion.FIREFOX36, (Object)UserAgentUtil.BrowserMajorVersion.FIREFOX_UNKNOWN, (Object)UserAgentUtil.BrowserMajorVersion.CHROME4, (Object)UserAgentUtil.BrowserMajorVersion.CHROME_UNKNOWN, (Object)UserAgentUtil.BrowserMajorVersion.SAFARI4, (Object[])new UserAgentUtil.BrowserMajorVersion[]{UserAgentUtil.BrowserMajorVersion.SAFARI_UNKNOWN});
    private static final ImmutableSet<UserAgentUtil.BrowserMajorVersion> INTERNET_EXPLORER = ImmutableSet.of((Object)UserAgentUtil.BrowserMajorVersion.MSIE8, (Object)UserAgentUtil.BrowserMajorVersion.MSIE9);
    private static final ImmutableSet<String> TEXT_EXTENSIONS = ImmutableSet.of((Object)".txt", (Object)".html", (Object)".htm", (Object)".xml", (Object)".xhtml");
    private static final ImmutableSet<String> TEXT_MIME_CONTENT_TYPE = ImmutableSet.of((Object)"text/plain", (Object)"text/html", (Object)"text/html-sandboxed", (Object)"text/xhtml", (Object)"application/xhtml+xml", (Object)"text/xml", (Object[])new String[]{"application/xml"});
    private static final ImmutableSet<String> EXECUTABLE_EXTENSIONS = ImmutableSet.of((Object)".svg", (Object)".swf", (Object)".cab", (Object)".flv", (Object)".f4v", (Object)".f4p", (Object[])new String[]{".f4a", ".f4b"});
    private static final ImmutableSet<String> EXECUTABLE_MIME_CONTENT_TYPES = ImmutableSet.of((Object)"text/xml-external-parsed-entity", (Object)"application/xml-external-parsed-entity", (Object)"application/xml-dtd", (Object)"application/x-shockwave-flash", (Object)"image/svg+xml", (Object)"image/svg-xml", (Object[])new String[]{"application/futuresplash"});
    private DownloadPolicyProvider mockPolicyProvider;
    private ContentDispositionHeaderGuesser contentDispositionGuesser;
    private HostileExtensionDetector hostileExtensionDetector;

    @Before
    public void setUp() throws Exception {
        this.hostileExtensionDetector = new HostileExtensionDetector();
        this.mockPolicyProvider = (DownloadPolicyProvider)Mockito.mock(DownloadPolicyProvider.class);
        this.contentDispositionGuesser = new ContentDispositionHeaderGuesser(this.mockPolicyProvider, this.hostileExtensionDetector);
    }

    @Test
    public void testSafeExtensionsShouldUseInlineHeaderWhenSmartMode() throws Exception {
        Mockito.when((Object)this.mockPolicyProvider.getPolicy()).thenReturn((Object)DownloadPolicy.Smart);
        for (String safeExtension : ImmutableSet.of((Object)".jpg", (Object)"png", (Object)".gif", (Object)".bmp")) {
            for (String contentType : ImmutableSet.of((Object)"application/octet-stream", (Object)"image/bmp", (Object)"image/png", (Object)"image/gif", (Object)"image/jpeg")) {
                for (UserAgentUtil.BrowserMajorVersion browser : Iterables.concat(GOOD_BROWSERS, INTERNET_EXPLORER)) {
                    this.assertHeaderIs("inline", "safe" + safeExtension, contentType, browser.getUserAgentString());
                    this.assertMimeTypeIs(contentType, "safe" + safeExtension, contentType, browser.getUserAgentString());
                }
            }
        }
    }

    @Test
    public void testSafeExtensionsShouldUseAttachmentHeaderWhenSecureMode() throws Exception {
        Mockito.when((Object)this.mockPolicyProvider.getPolicy()).thenReturn((Object)DownloadPolicy.Secure);
        for (String safeExtension : ImmutableSet.of((Object)".jpg", (Object)"png", (Object)".gif", (Object)".bmp")) {
            for (String contentType : ImmutableSet.of((Object)"application/octet-stream", (Object)"image/bmp", (Object)"image/png", (Object)"image/gif", (Object)"image/jpeg")) {
                for (UserAgentUtil.BrowserMajorVersion browser : Iterables.concat(GOOD_BROWSERS, INTERNET_EXPLORER)) {
                    this.assertHeaderIs("attachment", "safe" + safeExtension, contentType, browser.getUserAgentString());
                    this.assertMimeTypeIs(contentType, "safe" + safeExtension, contentType, browser.getUserAgentString());
                }
            }
        }
    }

    @Test
    public void testSafeExtensionsShouldUseInlineWhenInsecureMode() throws Exception {
        Mockito.when((Object)this.mockPolicyProvider.getPolicy()).thenReturn((Object)DownloadPolicy.Insecure);
        for (String safeExtension : ImmutableSet.of((Object)".jpg", (Object)"png", (Object)".gif", (Object)".bmp")) {
            for (String contentType : ImmutableSet.of((Object)"application/octet-stream", (Object)"image/bmp", (Object)"image/png", (Object)"image/gif", (Object)"image/jpeg")) {
                for (UserAgentUtil.BrowserMajorVersion browser : Iterables.concat(GOOD_BROWSERS, INTERNET_EXPLORER)) {
                    this.assertHeaderIs("inline", "safe" + safeExtension, contentType, browser.getUserAgentString());
                    this.assertMimeTypeIs(contentType, "safe" + safeExtension, contentType, browser.getUserAgentString());
                }
            }
        }
    }

    @Test
    public void testUnsafeExtensionShouldUseAttachmentHeaderWhenSmartMode() throws Exception {
        Mockito.when((Object)this.mockPolicyProvider.getPolicy()).thenReturn((Object)DownloadPolicy.Smart);
        for (String contentType : EXECUTABLE_MIME_CONTENT_TYPES) {
            for (String unsafeExt : EXECUTABLE_EXTENSIONS) {
                for (UserAgentUtil.BrowserMajorVersion browser : Iterables.concat(INTERNET_EXPLORER, GOOD_BROWSERS)) {
                    this.assertHeaderIs("attachment", "unsafe" + unsafeExt, contentType, browser.getUserAgentString());
                    this.assertMimeTypeIs(contentType, "safe" + unsafeExt, contentType, browser.getUserAgentString());
                }
            }
        }
    }

    @Test
    public void testUnsafeExtensionShouldUseAttachmentHeaderWhenSecureMode() throws Exception {
        Mockito.when((Object)this.mockPolicyProvider.getPolicy()).thenReturn((Object)DownloadPolicy.Secure);
        for (String contentType : EXECUTABLE_MIME_CONTENT_TYPES) {
            for (String unsafeExt : EXECUTABLE_EXTENSIONS) {
                for (UserAgentUtil.BrowserMajorVersion browser : Iterables.concat(INTERNET_EXPLORER, GOOD_BROWSERS)) {
                    this.assertHeaderIs("attachment", "unsafe" + unsafeExt, contentType, browser.getUserAgentString());
                    this.assertMimeTypeIs(contentType, "safe" + unsafeExt, contentType, browser.getUserAgentString());
                }
            }
        }
    }

    @Test
    public void testUnsafeExtensionShouldUseAttachmentHeaderWhenInsecureMode() throws Exception {
        Mockito.when((Object)this.mockPolicyProvider.getPolicy()).thenReturn((Object)DownloadPolicy.Insecure);
        for (String contentType : EXECUTABLE_MIME_CONTENT_TYPES) {
            for (String unsafeExt : EXECUTABLE_EXTENSIONS) {
                for (UserAgentUtil.BrowserMajorVersion browser : Iterables.concat(INTERNET_EXPLORER, GOOD_BROWSERS)) {
                    this.assertHeaderIs("inline", "unsafe" + unsafeExt, contentType, browser.getUserAgentString());
                    this.assertMimeTypeIs(contentType, "safe" + unsafeExt, contentType, browser.getUserAgentString());
                }
            }
        }
    }

    @Test
    public void testSpecialCaseIEHandlingForTextExtensionsWhenSmartMode() throws Exception {
        Mockito.when((Object)this.mockPolicyProvider.getPolicy()).thenReturn((Object)DownloadPolicy.Smart);
        for (String textExtension : TEXT_EXTENSIONS) {
            for (String textMimeType : TEXT_MIME_CONTENT_TYPE) {
                for (UserAgentUtil.BrowserMajorVersion browser : INTERNET_EXPLORER) {
                    this.assertHeaderIs("attachment", "safe" + textExtension, textMimeType, browser.getUserAgentString());
                    this.assertMimeTypeIs(textMimeType, "safe" + textExtension, textMimeType, browser.getUserAgentString());
                }
                for (UserAgentUtil.BrowserMajorVersion browser : GOOD_BROWSERS) {
                    this.assertHeaderIs("inline", "safe" + textExtension, textMimeType, textMimeType);
                    this.assertMimeTypeIs("text/plain", "safe" + textExtension, textMimeType, browser.getUserAgentString());
                }
            }
        }
    }

    @Test
    public void testSpecialCaseIEHandlingForTextExtensionsWhenSecureMode() throws Exception {
        Mockito.when((Object)this.mockPolicyProvider.getPolicy()).thenReturn((Object)DownloadPolicy.Secure);
        for (String textExtension : TEXT_EXTENSIONS) {
            for (String textMimeType : TEXT_MIME_CONTENT_TYPE) {
                for (UserAgentUtil.BrowserMajorVersion browser : Iterables.concat(INTERNET_EXPLORER, GOOD_BROWSERS)) {
                    this.assertHeaderIs("attachment", "safe" + textExtension, textMimeType, browser.getUserAgentString());
                    this.assertMimeTypeIs(textMimeType, "safe" + textExtension, textMimeType, browser.getUserAgentString());
                }
            }
        }
    }

    @Test
    public void testSpecialCaseIEHandlingForTextExtensionsWhenInsecureMode() throws Exception {
        Mockito.when((Object)this.mockPolicyProvider.getPolicy()).thenReturn((Object)DownloadPolicy.Insecure);
        for (String textExtension : TEXT_EXTENSIONS) {
            for (String textMimeType : TEXT_MIME_CONTENT_TYPE) {
                for (UserAgentUtil.BrowserMajorVersion browser : Iterables.concat(INTERNET_EXPLORER, GOOD_BROWSERS)) {
                    this.assertHeaderIs("inline", "safe" + textExtension, textMimeType, browser.getUserAgentString());
                    this.assertMimeTypeIs(textMimeType, "safe" + textExtension, textMimeType, browser.getUserAgentString());
                }
            }
        }
    }

    private void assertMimeTypeIs(String expectedMimeReturned, String filename, String givenMimeType, String browserUserAgent) {
        Assert.assertEquals((String)("wrong header for filename=" + filename + " and mime=" + givenMimeType + " and userAgent=" + browserUserAgent), (Object)expectedMimeReturned, (Object)this.contentDispositionGuesser.guessMIME(filename, givenMimeType, browserUserAgent));
    }

    private void assertHeaderIs(String expectedHeader, String extension, String mimeContentType, String userAgentStr) {
        Assert.assertEquals((String)("wrong header for extension=" + extension + " and mime=" + mimeContentType + " and userAgent=" + userAgentStr), (Object)expectedHeader, (Object)this.contentDispositionGuesser.guessContentDispositionHeader(extension, mimeContentType, userAgentStr));
    }
}

