/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.mime;

import com.cenqua.fisheye.web.mime.BrowserUtils;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class BrowserUtilsTest {
    private static String IE6_WINXP = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)";
    private static String IE7_WINVISTA = "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET4.0C; .NET CLR 3.0.30729)";
    private static String IE8_SERVER2008 = "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; WOW64; Trident/4.0; SLCC2; .NET CLR 2.0.50727)";
    private static String IE9_WINDOWS7 = "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)";
    private static String FIREFOX_WINDOWS = "Mozilla/5.0 (Windows NT 6.1; rv:16.0) Gecko/20100101 Firefox/16.0";
    private static String FIREFOX_MAC = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:16.0) Gecko/20100101 Firefox/16.0";
    private static String FIREFOX_LINUX = "Mozilla/5.0 (X11; Linux x86_64; rv:16.0) Gecko/20100101 Firefox/16.0";
    private static String CHROME_MAC = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.4 (KHTML, like Gecko) Chrome/22.0.1229.94 Safari/537.4";
    private static String SAFARI_MAC = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14";
    private static String OPERA_MAC = "Opera/9.80 (Macintosh; Intel Mac OS X 10.8.2; U; en) Presto/2.10.289 Version/12.00";
    private static String ANONYMOUS = null;

    @Test
    public void testIsIE() throws Exception {
        Assert.assertTrue((boolean)BrowserUtils.isIE((String)IE6_WINXP));
        Assert.assertTrue((boolean)BrowserUtils.isIE((String)IE7_WINVISTA));
        Assert.assertTrue((boolean)BrowserUtils.isIE((String)IE8_SERVER2008));
        Assert.assertTrue((boolean)BrowserUtils.isIE((String)IE9_WINDOWS7));
        Assert.assertFalse((boolean)BrowserUtils.isIE((String)FIREFOX_WINDOWS));
        Assert.assertFalse((boolean)BrowserUtils.isIE((String)FIREFOX_MAC));
        Assert.assertFalse((boolean)BrowserUtils.isIE((String)FIREFOX_LINUX));
        Assert.assertFalse((boolean)BrowserUtils.isIE((String)CHROME_MAC));
        Assert.assertFalse((boolean)BrowserUtils.isIE((String)SAFARI_MAC));
        Assert.assertFalse((boolean)BrowserUtils.isIE((String)OPERA_MAC));
        Assert.assertFalse((boolean)BrowserUtils.isIE((String)ANONYMOUS));
    }

    @Test
    public void testIsIERequest() throws Exception {
        Assert.assertTrue((boolean)BrowserUtils.isIE((HttpServletRequest)this.mockRequest(IE6_WINXP)));
        Assert.assertTrue((boolean)BrowserUtils.isIE((HttpServletRequest)this.mockRequest(IE7_WINVISTA)));
        Assert.assertTrue((boolean)BrowserUtils.isIE((HttpServletRequest)this.mockRequest(IE8_SERVER2008)));
        Assert.assertTrue((boolean)BrowserUtils.isIE((HttpServletRequest)this.mockRequest(IE9_WINDOWS7)));
        Assert.assertFalse((boolean)BrowserUtils.isIE((HttpServletRequest)this.mockRequest(FIREFOX_WINDOWS)));
        Assert.assertFalse((boolean)BrowserUtils.isIE((HttpServletRequest)this.mockRequest(FIREFOX_MAC)));
        Assert.assertFalse((boolean)BrowserUtils.isIE((HttpServletRequest)this.mockRequest(FIREFOX_LINUX)));
        Assert.assertFalse((boolean)BrowserUtils.isIE((HttpServletRequest)this.mockRequest(CHROME_MAC)));
        Assert.assertFalse((boolean)BrowserUtils.isIE((HttpServletRequest)this.mockRequest(SAFARI_MAC)));
        Assert.assertFalse((boolean)BrowserUtils.isIE((HttpServletRequest)this.mockRequest(OPERA_MAC)));
        Assert.assertFalse((boolean)BrowserUtils.isIE((HttpServletRequest)this.mockRequest(ANONYMOUS)));
        Assert.assertFalse((boolean)BrowserUtils.isIE((HttpServletRequest)null));
    }

    public HttpServletRequest mockRequest(String userAgent) throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getHeader(Mockito.anyString())).thenReturn((Object)userAgent);
        return request;
    }
}

