/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.cenqua.fisheye.web.filters.DummyHttpServletRequest;
import com.cenqua.fisheye.web.filters.SnippetRewrite;
import com.cenqua.fisheye.web.util.WrappedRequest;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;

public class SnippetRewriteTest
extends TestCase {
    public void testURLs() {
        SnippetRewrite rule = new SnippetRewrite();
        DummyHttpServletRequest sreq = new DummyHttpServletRequest();
        WrappedRequest req = new WrappedRequest((HttpServletRequest)sreq);
        Matcher m = rule.applyRule("/snippet/CR-123");
        SnippetRewriteTest.assertTrue((m != null ? 1 : 0) != 0);
        SnippetRewriteTest.assertEquals((String)rule.rewrite(m, req), (String)"/cru/CR-123");
        m = rule.applyRule("/snippet/CR-1-123");
        SnippetRewriteTest.assertTrue((m != null ? 1 : 0) != 0);
        SnippetRewriteTest.assertEquals((String)rule.rewrite(m, req), (String)"/cru/CR-1-123");
        m = rule.applyRule("/snippet/CR-1-123/foo/bar/print");
        SnippetRewriteTest.assertTrue((m != null ? 1 : 0) != 0);
        SnippetRewriteTest.assertEquals((String)rule.rewrite(m, req), (String)"/cru/CR-1-123/foo/bar/print");
        m = rule.applyRule("/snippet/BLAH");
        SnippetRewriteTest.assertTrue((m != null ? 1 : 0) != 0);
        SnippetRewriteTest.assertEquals((String)rule.rewrite(m, req), (String)"/cru/BLAH");
        m = rule.applyRule("/snippet/");
        SnippetRewriteTest.assertTrue((m != null ? 1 : 0) != 0);
        SnippetRewriteTest.assertEquals((String)rule.rewrite(m, req), (String)"/cru/");
        m = rule.applyRule("/snippet/create");
        SnippetRewriteTest.assertTrue((m != null ? 1 : 0) != 0);
        SnippetRewriteTest.assertEquals((String)rule.rewrite(m, req), (String)"/cru/createSnippet");
        m = rule.applyRule("/cru/cr-123");
        SnippetRewriteTest.assertTrue((m == null ? 1 : 0) != 0);
        m = rule.applyRule("/preview/fred-1");
        SnippetRewriteTest.assertTrue((m == null ? 1 : 0) != 0);
        m = rule.applyRule("/cru/fred");
        SnippetRewriteTest.assertTrue((m == null ? 1 : 0) != 0);
    }
}

