/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.cenqua.fisheye.web.filters.DummyHttpServletRequest;
import com.cenqua.fisheye.web.filters.ReviewPermaIdRewrite;
import com.cenqua.fisheye.web.filters.RewriteRule;
import com.cenqua.fisheye.web.util.WrappedRequest;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class ReviewPermaIdRewriteTest
extends TestCase {
    private RewriteRule rule;
    private HttpServletRequest mockRequest;
    private WrappedRequest req;

    protected void setUp() throws Exception {
        this.rule = new ReviewPermaIdRewrite();
        this.mockRequest = (HttpServletRequest)Mockito.mock(DummyHttpServletRequest.class, (Answer)Mockito.CALLS_REAL_METHODS);
        this.req = new WrappedRequest(this.mockRequest);
    }

    public void testURLs() {
        Matcher m = this.rule.applyRule("/cru/fred-23");
        ReviewPermaIdRewriteTest.assertTrue((m != null ? 1 : 0) != 0);
        ReviewPermaIdRewriteTest.assertEquals((String)this.rule.rewrite(m, this.req), (String)"/cru/review.do");
        ReviewPermaIdRewriteTest.assertEquals((String)this.req.getParameter("permaKeyNumber"), (String)"23");
        ReviewPermaIdRewriteTest.assertEquals((String)this.req.getParameter("permaKeyProject"), (String)"FRED");
        m = this.rule.applyRule("/cru/fred-23/preview");
        ReviewPermaIdRewriteTest.assertTrue((m != null ? 1 : 0) != 0);
        ReviewPermaIdRewriteTest.assertEquals((String)this.rule.rewrite(m, this.req), (String)"/cru/preview.do");
        ReviewPermaIdRewriteTest.assertEquals((String)this.req.getParameter("permaKeyNumber"), (String)"23");
        ReviewPermaIdRewriteTest.assertEquals((String)this.req.getParameter("permaKeyProject"), (String)"FRED");
        m = this.rule.applyRule("/cru/fr-ed-1");
        ReviewPermaIdRewriteTest.assertTrue((m != null ? 1 : 0) != 0);
        ReviewPermaIdRewriteTest.assertEquals((String)this.rule.rewrite(m, this.req), (String)"/cru/review.do");
        ReviewPermaIdRewriteTest.assertEquals((String)this.req.getParameter("permaKeyNumber"), (String)"1");
        ReviewPermaIdRewriteTest.assertEquals((String)this.req.getParameter("permaKeyProject"), (String)"FR-ED");
        m = this.rule.applyRule("/cru/fr-22-1");
        ReviewPermaIdRewriteTest.assertTrue((m != null ? 1 : 0) != 0);
        ReviewPermaIdRewriteTest.assertEquals((String)this.rule.rewrite(m, this.req), (String)"/cru/review.do");
        ReviewPermaIdRewriteTest.assertEquals((String)this.req.getParameter("permaKeyNumber"), (String)"1");
        ReviewPermaIdRewriteTest.assertEquals((String)this.req.getParameter("permaKeyProject"), (String)"FR-22");
        m = this.rule.applyRule("/cru/fr-#-1");
        ReviewPermaIdRewriteTest.assertTrue((m == null ? 1 : 0) != 0);
        m = this.rule.applyRule("/preview/fred-1");
        ReviewPermaIdRewriteTest.assertTrue((m == null ? 1 : 0) != 0);
        m = this.rule.applyRule("/cru/fred");
        ReviewPermaIdRewriteTest.assertTrue((m == null ? 1 : 0) != 0);
    }

    public void testRewriteWithCommandForNonAjax() {
        this.req.setParameter("command", "upload");
        Matcher m = this.rule.applyRule("/cru/fred-23/action/");
        ReviewPermaIdRewriteTest.assertTrue((m != null ? 1 : 0) != 0);
        ReviewPermaIdRewriteTest.assertEquals((String)this.rule.rewrite(m, this.req), (String)"/cru/action-upload.do");
        ReviewPermaIdRewriteTest.assertEquals((String)this.req.getParameter("permaKeyNumber"), (String)"23");
        ReviewPermaIdRewriteTest.assertEquals((String)this.req.getParameter("permaKeyProject"), (String)"FRED");
    }

    public void testRewriteWithCommandForAjax() {
        this.req.setParameter("command", "upload");
        Mockito.when((Object)this.mockRequest.getHeader("X-Requested-With")).thenReturn((Object)"XMLHttpRequest");
        Matcher m = this.rule.applyRule("/cru/fred-23/action/");
        ReviewPermaIdRewriteTest.assertTrue((m != null ? 1 : 0) != 0);
        ReviewPermaIdRewriteTest.assertEquals((String)this.rule.rewrite(m, this.req), (String)"/cru/action.do");
        ReviewPermaIdRewriteTest.assertEquals((String)this.req.getParameter("permaKeyNumber"), (String)"23");
        ReviewPermaIdRewriteTest.assertEquals((String)this.req.getParameter("permaKeyProject"), (String)"FRED");
    }
}

