/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.cenqua.fisheye.web.filters.DummyHttpServletRequest;
import com.cenqua.fisheye.web.filters.QuickSearchRewriteRule;
import com.cenqua.fisheye.web.filters.RewriteRule;
import com.cenqua.fisheye.web.util.WrappedRequest;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;

public class QuickSearchRewriteRuleTest
extends TestCase {
    private final RewriteRule rule = new QuickSearchRewriteRule();

    public void testRewrite() throws Exception {
        String sourceUrl = "/qsearch";
        String targetUrl = "/fe/quicksearch.do";
        Map<String, String> parameters = Collections.emptyMap();
        this.assertRewrite(this.rule, "/qsearch", "/fe/quicksearch.do", parameters);
    }

    public void testRewriteWithEmptySlash() throws Exception {
        String sourceUrl = "/qsearch/";
        String targetUrl = "/fe/quicksearch.do";
        Map<String, String> parameters = Collections.emptyMap();
        this.assertRewrite(this.rule, "/qsearch/", "/fe/quicksearch.do", parameters);
    }

    public void testRewriteWithRepository() throws Exception {
        String sourceUrl = "/qsearch/testrepository";
        String targetUrl = "/fe/quicksearch.do";
        Map<String, String> parameters = Collections.singletonMap("repository", "testrepository");
        this.assertRewrite(this.rule, "/qsearch/testrepository", "/fe/quicksearch.do", parameters);
    }

    private void assertRewrite(RewriteRule rule, String sourceUrl, String targetUrl, Map<String, String> requiredParams) {
        WrappedRequest request = new WrappedRequest((HttpServletRequest)new DummyHttpServletRequest());
        Matcher m = rule.applyRule(sourceUrl);
        QuickSearchRewriteRuleTest.assertTrue((String)("Rule not applied for URL: " + sourceUrl), (m != null ? 1 : 0) != 0);
        QuickSearchRewriteRuleTest.assertEquals((String)targetUrl, (String)rule.rewrite(m, request));
        for (Map.Entry<String, String> parameter : requiredParams.entrySet()) {
            QuickSearchRewriteRuleTest.assertEquals((String)request.getParameter(parameter.getKey()), (String)parameter.getValue());
        }
    }
}

