/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.cenqua.fisheye.web.filters.JsonRewrite;
import com.cenqua.fisheye.web.util.WrappedRequest;
import java.util.regex.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;

public class JsonRewriteTest {
    private JsonRewrite rule = new JsonRewrite();

    @Test
    public void testJsonDoesntMatch() throws Exception {
        this.testUri("/rest/api/1.0/", null);
    }

    @Test
    public void testJsonRewriteCru() throws Exception {
        this.testUri("/json/cru/action.do", "/cru/action.do");
    }

    @Test
    public void testJsonRewriteFe() throws Exception {
        this.testUri("/json/fe/action.do", "/fe/action.do");
    }

    @Test
    public void testJsonRewriteAction() throws Exception {
        this.testUri("/json/action/action.do", "/action/action.do");
    }

    @Test
    public void testJsonRewriteProfile() throws Exception {
        this.testUri("/json/profile/action.do", "/profile/action.do");
    }

    @Test
    public void testJsonRewriteChangelog() throws Exception {
        this.testUri("/json/changelog/action.do", "/changelog/action.do");
    }

    @Test
    public void testJsonRewriteBrowse() throws Exception {
        this.testUri("/json/browse/action.do", "/browse/action.do");
    }

    @Test
    public void testJsonDoesntRewriteWebinf() throws Exception {
        this.testUri("/json/WEB-INF/top-secret.properties", null);
    }

    @Test
    public void testJsonDoesntRewriteWebinfWindows() throws Exception {
        this.testUri("/json/web-inf/top-secret.properties", null);
    }

    protected void testUri(String uri, String expected) {
        String result = null;
        Matcher matcher = this.rule.applyRule(uri);
        if (matcher != null) {
            WrappedRequest mockedWrappedRequest = (WrappedRequest)Mockito.mock(WrappedRequest.class);
            result = this.rule.rewrite(matcher, mockedWrappedRequest);
        }
        MatcherAssert.assertThat(result, (org.hamcrest.Matcher)Matchers.equalTo((Object)expected));
    }
}

