/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.Auth;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.actions.user.UserEditAdminAction;
import com.google.common.base.Strings;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class UserEditAdminActionTest {
    private static final String USERNAME = "TestUser";
    private static final String DISPLAY_NAME = "Test User";
    private static final String EMAIL = "test@user.test";
    @Mock
    UserManager userManager;
    @Mock
    Auth auth;
    @InjectMocks
    UserEditAdminAction action = new UserEditAdminAction();
    FecruUser user;

    @Before
    public void setUp() throws Exception {
        this.user = new FecruUser(USERNAME);
        this.action.setUname(USERNAME);
        this.action.setUserDisplayName(DISPLAY_NAME);
        this.action.setUserEmail(EMAIL);
        Mockito.when((Object)this.userManager.getLicensedUser(USERNAME)).thenReturn((Object)this.user);
    }

    @Test
    public void testErrorMessageWhenEmailIsTaken() throws Exception {
        this.action.setUserDisplayName(DISPLAY_NAME);
        this.action.setUserEmail(EMAIL);
        Mockito.when((Object)this.userManager.getUsernameByEmail(EMAIL)).thenReturn((Object)"dummyuser");
        this.action.validate();
        MatcherAssert.assertThat((Object)this.action.getFieldErrors("userEmail"), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"Email address must be unique, currently used by dummyuser"}));
    }

    @Test
    public void testErrorMessageWhenDBConnectionFailOnValidate() throws Exception {
        this.action.setUserDisplayName(DISPLAY_NAME);
        this.action.setUserEmail(EMAIL);
        Mockito.when((Object)this.userManager.addUser(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean())).thenReturn((Object)this.user);
        Mockito.when((Object)this.userManager.getUsernameByEmail(EMAIL)).thenThrow(new Throwable[]{new DbException("DbException")});
        this.action.validate();
        MatcherAssert.assertThat((Object)((List)this.action.getActionErrors()), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"The user could not be validated. DbException. Please check the system logs for details."}));
    }

    @Test
    public void testErrorMessageInvalidEmail() throws Exception {
        Mockito.when((Object)this.userManager.canUpdateUser(Matchers.anyString())).thenReturn((Object)true);
        this.action.setUserDisplayName(DISPLAY_NAME);
        Mockito.when((Object)this.userManager.addUser(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean())).thenReturn((Object)this.user);
        this.action.setUserEmail("bob%lablaw.com");
        this.action.validate();
        MatcherAssert.assertThat((Object)this.action.getFieldErrors("userEmail"), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"The provided email address is invalid"}));
    }

    @Test
    public void testErrorMessageDisplayNameTooLong() throws Exception {
        Mockito.when((Object)this.userManager.canUpdateUser(Matchers.anyString())).thenReturn((Object)true);
        this.action.setUserEmail(EMAIL);
        this.action.setUserDisplayName(Strings.repeat((String)"a", (int)256));
        this.action.validate();
        MatcherAssert.assertThat((Object)this.action.getFieldErrors("userDisplayName"), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"Display name must be 255 characters or less."}));
    }

    @Test
    public void testNoErrorsExternalUser() throws Exception {
        Mockito.when((Object)this.userManager.getAuthenticationProvider()).thenReturn((Object)this.auth);
        Mockito.when((Object)this.auth.isRefreshExistingUsers()).thenReturn((Object)true);
        this.action.validate();
        Assert.assertNull((Object)this.action.getFieldErrors("userDisplayName"));
        Assert.assertNull((Object)this.action.getFieldErrors("userEmail"));
        MatcherAssert.assertThat((Object)this.action.hasErrors(), (Matcher)org.hamcrest.Matchers.is((Object)false));
    }
}

