/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.web.admin.actions.user.BulkEditType;
import com.cenqua.fisheye.web.admin.actions.user.UserAdminAction;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class UserAdminActionTest {
    private RootConfig mockConfig;
    private UserAdminAction userAdminAction;

    @Before
    public void setUp() throws Exception {
        this.mockConfig = (RootConfig)Mockito.mock(RootConfig.class);
        this.userAdminAction = new UserAdminAction(this.mockConfig);
    }

    @Test
    public void testFECRUInstanceGetBulkEditTypesReturnsAll() throws Exception {
        Mockito.when((Object)this.mockConfig.isCrucibleOnly()).thenReturn((Object)false);
        Mockito.when((Object)this.mockConfig.isFishEyeOnly()).thenReturn((Object)false);
        BulkEditType[] result = this.userAdminAction.getBulkEditTypes();
        Assert.assertThat((String)"On FECRU instance all actions should be available", Arrays.asList(result), (Matcher)Matchers.containsInAnyOrder((Object[])new BulkEditType[]{BulkEditType.DELETE}));
    }

    @Test
    public void testFEOnlyInstanceGetBulkEditTypesReturnsDeleteOnly() throws Exception {
        Mockito.when((Object)this.mockConfig.isCrucibleOnly()).thenReturn((Object)false);
        Mockito.when((Object)this.mockConfig.isFishEyeOnly()).thenReturn((Object)true);
        BulkEditType[] result = this.userAdminAction.getBulkEditTypes();
        Assert.assertThat((String)"On FE instance only DELETE bulk action should be available", Arrays.asList(result), (Matcher)Matchers.containsInAnyOrder((Object[])new BulkEditType[]{BulkEditType.DELETE}));
    }

    @Test
    public void testCRUCOnlyInstanceGetBulkEditTypesReturnsDeleteOnly() throws Exception {
        Mockito.when((Object)this.mockConfig.isCrucibleOnly()).thenReturn((Object)true);
        Mockito.when((Object)this.mockConfig.isFishEyeOnly()).thenReturn((Object)false);
        BulkEditType[] result = this.userAdminAction.getBulkEditTypes();
        Assert.assertThat((String)"On CRUC instance only DELETE bulk action should be available", Arrays.asList(result), (Matcher)Matchers.containsInAnyOrder((Object[])new BulkEditType[]{BulkEditType.DELETE}));
    }
}

