/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.actions.user.UserAddAdminAction;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class UserAddAdminActionTest {
    private static final String USERNAME = "testuser";
    private static final String DISPLAY_NAME = "Test User";
    private static final String EMAIL = "test@user.test";
    private static final String PASSWORD = "password";
    @Mock
    UserManager userManager;
    @InjectMocks
    UserAddAdminAction action = new UserAddAdminAction();
    FecruUser user;

    @Before
    public void setUp() throws Exception {
        this.user = new FecruUser(USERNAME);
        this.action.setUsername(USERNAME);
        this.action.setUserDisplayName(DISPLAY_NAME);
        this.action.setUserEmail(EMAIL);
        this.action.setPassword1(PASSWORD);
        this.action.setPassword2(PASSWORD);
    }

    @Test
    public void testErrorMessageWhenUsernameIsTaken() throws Exception {
        Mockito.when((Object)this.userManager.existsEnabledUser(USERNAME)).thenReturn((Object)true);
        Mockito.when((Object)this.userManager.isUserNameValid(USERNAME)).thenReturn((Object)true);
        this.action.validate();
        MatcherAssert.assertThat((Object)this.action.getFieldErrors("username"), (Matcher)org.hamcrest.Matchers.contains((Matcher)org.hamcrest.Matchers.is((Object)"An user with that name already exists")));
    }

    @Test
    public void testErrorMessageWhenEmailIsTaken() throws Exception {
        Mockito.when((Object)this.userManager.getUsernameByEmail(EMAIL)).thenReturn((Object)"dummyuser");
        this.action.validate();
        MatcherAssert.assertThat((Object)this.action.getFieldErrors("userEmail"), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"The user's email address must be unique, but it is currently used by dummyuser"}));
    }

    @Test
    public void testErrorMessageWhenDBConnectionFailOnExecute() throws Exception {
        Mockito.when((Object)this.userManager.addUser(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean())).thenThrow(new Throwable[]{new DbException("DbException")});
        this.action.execute();
        MatcherAssert.assertThat((Object)((List)this.action.getActionErrors()), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"The user could not be created. DbException. Please check the system logs for details."}));
    }

    @Test
    public void testErrorMessageWhenDBConnectionFailOnValidate() throws Exception {
        Mockito.when((Object)this.userManager.addUser(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean())).thenReturn((Object)this.user);
        Mockito.when((Object)this.userManager.getUsernameByEmail(EMAIL)).thenThrow(new Throwable[]{new DbException("DbException")});
        this.action.validate();
        MatcherAssert.assertThat((Object)((List)this.action.getActionErrors()), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"Failed validating user. DbException. Please check the system logs for details."}));
    }

    @Test
    public void shouldTryToAddUserToDefaultGroups() throws Exception {
        Mockito.when((Object)this.userManager.addUser(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean())).thenReturn((Object)this.user);
        this.action.execute();
        ((UserManager)Mockito.verify((Object)this.userManager)).addUser(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.eq((boolean)true));
    }
}

