/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.fecru.properties.UserRepositoryPropertyManager;
import com.atlassian.fecru.user.DummyFecruUserDAO;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.LoginCookieDAO;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.impl.DummyTxTemplate;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.DefaultUserManager;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.login.PasswordResetAction;
import com.cenqua.fisheye.web.login.RequestPasswordResetAction;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class PasswordResetTest {
    private final CrowdService crowdService = (CrowdService)Mockito.mock(CrowdService.class);
    private final UserRepositoryPropertyManager userRepositoryPropertyManager = (UserRepositoryPropertyManager)Mockito.mock(UserRepositoryPropertyManager.class);
    private DummyFecruUserDAO userDAO;
    private LoginCookieDAO loginCookieDAO;
    private UserManager userManager;
    private boolean canUpdateUser = true;

    @Before
    public void setUp() throws Exception {
        this.userDAO = new DummyFecruUserDAO();
        this.loginCookieDAO = (LoginCookieDAO)Mockito.mock(LoginCookieDAO.class);
        this.userManager = (UserManager)Mockito.spy((Object)new DefaultUserManager(this.loginCookieDAO, null, this.userDAO, (TxTemplate)new DummyTxTemplate(), (RootConfig)Mockito.mock(RootConfig.class), null, null, (DirectoryManager)Mockito.mock(DirectoryManager.class), (AuthenticationController)Mockito.mock(AuthenticationController.class), this.userRepositoryPropertyManager, this.crowdService, null, null, null, null, null, null){

            public boolean canUpdateUser(String username) {
                return PasswordResetTest.this.canUpdateUser;
            }

            public boolean isPasswordlessAuthenticationEnabled() {
                return false;
            }
        });
    }

    @Test
    public void testNoSMTPServer() throws Exception {
        RequestPasswordResetActionUnderTest action = new RequestPasswordResetActionUnderTest(){

            @Override
            protected boolean isMailServerConfigured() {
                return false;
            }
        };
        action.doDefault();
        action.setCaptchaResponse("hardToRead");
        action.validate();
        this.assertErrors("No SMTP server configured", action.getErrorMessages());
    }

    @Test
    public void testNoUserOrEmail() throws Exception {
        RequestPasswordResetActionUnderTest action = new RequestPasswordResetActionUnderTest();
        action.doDefault();
        action.setCaptchaResponse("hardToRead");
        action.validate();
        this.assertErrors("You must specify a username or email", action.getErrorMessages());
    }

    @Test
    public void testNoCaptcha() throws Exception {
        RequestPasswordResetActionUnderTest action = new RequestPasswordResetActionUnderTest();
        action.doDefault();
        action.validate();
        junit.framework.Assert.assertEquals((Object)"Please enter the word in the image.", ((ArrayList)action.getFieldErrors().get("captchaResponse")).get(0));
    }

    @Test
    public void testNoUserForEmail() throws Exception {
        this.testNoUserFor("tim@atlassian.com");
    }

    @Test
    public void testNoUserForName() throws Exception {
        this.testNoUserFor("tim");
    }

    private void testNoUserFor(String usernameOrEmail) throws Exception {
        RequestPasswordResetActionUnderTest action = new RequestPasswordResetActionUnderTest(){
            {
                this.setUserManager(PasswordResetTest.this.userManager);
            }

            protected boolean sendEmail(FecruUser user, Map<String, Object> fMParams, String templateName, String subject) throws IOException, TemplateException, DbException {
                throw new AssertionError((Object)"No mail should be sent in this case");
            }

            protected boolean sendVerificationEmail(FecruUser user, String code) throws IOException, TemplateException, DbException {
                throw new AssertionError((Object)"No mail should be sent in this case");
            }

            protected String getUsernameFromEmail(String email) throws DbException {
                return null;
            }
        };
        action.setCaptchaResponse("hardToRead");
        action.setUsernameOrEmail(usernameOrEmail);
        action.doDefault();
        action.validate();
        junit.framework.Assert.assertFalse((boolean)action.hasErrors());
        junit.framework.Assert.assertEquals((String)"success", (String)action.execute());
        ((LoginCookieDAO)Mockito.verify((Object)this.loginCookieDAO, (VerificationMode)Mockito.never())).deleteCookiesForUser((FecruUser)org.mockito.Matchers.anyObject());
    }

    @Test
    public void testExternalAuthUser() throws Exception {
        RequestPasswordResetActionUnderTest action = new RequestPasswordResetActionUnderTest(){
            {
                this.setUserManager(PasswordResetTest.this.userManager);
            }
        };
        this.canUpdateUser = false;
        this.addUser("tim");
        action.setCaptchaResponse("hardToRead");
        action.setUsernameOrEmail("tim");
        action.doDefault();
        action.validate();
        this.assertErrors("Cannot update password for specified user", action.getErrorMessages());
    }

    @Test
    public void testFailedCaptcha() throws Exception {
        RequestPasswordResetActionUnderTest action = new RequestPasswordResetActionUnderTest(){

            @Override
            protected Boolean validateCaptchaResponse() {
                return Boolean.FALSE;
            }
        };
        this.addUser("tim");
        action.setCaptchaResponse("hardToRead");
        action.setUsernameOrEmail("tim");
        action.doDefault();
        action.validate();
        junit.framework.Assert.assertEquals((Object)"Incorrect, try again.", ((ArrayList)action.getFieldErrors().get("captchaResponse")).get(0));
    }

    @Test
    public void testSendVerificationFail() throws Exception {
        final FecruUser tim = this.addUser("tim");
        RequestPasswordResetActionUnderTest action = new RequestPasswordResetActionUnderTest(){

            protected boolean sendEmail(FecruUser user, Map<String, Object> fMParams, String templateName, String subject) throws IOException, TemplateException, DbException {
                junit.framework.Assert.assertEquals((String)"tim", (String)user.getUsername());
                junit.framework.Assert.assertEquals((String)"CAFEBABE", (String)((String)fMParams.get("code")));
                junit.framework.Assert.assertEquals((String)"verify-password-reset.ftl", (String)templateName);
                junit.framework.Assert.assertEquals((String)(AppConfig.getProductName() + " Password Reset"), (String)subject);
                return false;
            }

            protected boolean sendVerificationEmail(FecruUser user, String code) throws IOException, TemplateException, DbException {
                return false;
            }

            protected FecruUser validateUser() {
                return tim;
            }
        };
        action.setUsernameOrEmail("tim@atlassian.com");
        action.setCaptchaResponse("hardToRead");
        action.doDefault();
        action.validate();
        junit.framework.Assert.assertEquals((String)"input", (String)action.execute());
        this.assertErrors("Failed to send verification email", action.getErrorMessages());
        ((UserRepositoryPropertyManager)Mockito.verify((Object)this.userRepositoryPropertyManager, (VerificationMode)Mockito.never())).saveGlobalProperty((FecruUser)org.mockito.Matchers.any(FecruUser.class), org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString());
    }

    @Test
    public void testUserHasNotRequestedReset() throws DbException {
        PasswordResetActionUnderTest action = this.createPasswordResetAction();
        this.addUser("tim");
        action.setUsernameOrEmail("tim");
        action.validate();
        this.assertErrors("User has not requested password reset or bad verification code was provided", action.getErrorMessages());
    }

    private PasswordResetActionUnderTest createPasswordResetAction() {
        return new PasswordResetActionUnderTest(){
            {
                this.setUserManager(PasswordResetTest.this.userManager);
            }
        };
    }

    @Test
    public void testBadVerificationCode() throws DbException {
        PasswordResetActionUnderTest action = this.createPasswordResetAction();
        this.addUser("tim");
        action.setCode("ABABAABA");
        action.setUsernameOrEmail("tim");
        this.addPasswordResetRequest("tim");
        action.validate();
        this.assertErrors("User has not requested password reset or bad verification code was provided", action.getErrorMessages());
    }

    @Test
    public void testExpiredVerificationCode() throws DbException {
        PasswordResetActionUnderTest action = this.createPasswordResetAction();
        this.addUser("tim");
        action.setCode("CAFEBABE");
        action.setUsernameOrEmail("tim");
        this.addExpiredPasswordResetRequest("tim");
        action.validate();
        this.assertErrors("Verification code expired", action.getErrorMessages());
    }

    @Test
    public void testSendNewPasswordFail() throws Exception {
        final FecruUser tim = this.addUser("tim");
        PasswordResetActionUnderTest action = new PasswordResetActionUnderTest(){

            protected boolean sendEmail(FecruUser user, Map<String, Object> fMParams, String templateName, String subject) throws IOException, TemplateException, DbException {
                junit.framework.Assert.assertEquals((String)"tim", (String)user.getUsername());
                junit.framework.Assert.assertEquals((String)"SECRET", (String)((String)fMParams.get("password")));
                junit.framework.Assert.assertEquals((String)"password-reset.ftl", (String)templateName);
                junit.framework.Assert.assertEquals((String)"New FishEye Password", (String)subject);
                return false;
            }

            protected boolean sendPasswordEmail(FecruUser user, String newPassword) throws IOException, TemplateException, DbException {
                return false;
            }

            protected FecruUser validateUser() {
                return tim;
            }
        };
        action.setCode("CAFEBABE");
        action.setUsernameOrEmail("tim@atlassian.com");
        this.addPasswordResetRequest("tim");
        action.validate();
        junit.framework.Assert.assertEquals((String)"input", (String)action.execute());
        this.assertErrors("Failed to send password email", action.getErrorMessages());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.crowdService});
    }

    @Test
    public void testHappyPath() throws Exception {
        final FecruUser tim = this.addUser("tim");
        RequestPasswordResetActionUnderTest requestAction = new RequestPasswordResetActionUnderTest(){
            {
                this.setUserManager(PasswordResetTest.this.userManager);
            }

            protected boolean sendEmail(FecruUser user, Map<String, Object> fMParams, String templateName, String subject) throws IOException, TemplateException, DbException {
                return true;
            }

            protected boolean sendVerificationEmail(FecruUser user, String code) throws IOException, TemplateException, DbException {
                return true;
            }
        };
        PasswordResetActionUnderTest action = new PasswordResetActionUnderTest(){
            {
                this.setUserManager(PasswordResetTest.this.userManager);
            }

            protected boolean sendEmail(FecruUser user, Map<String, Object> fMParams, String templateName, String subject) throws IOException, TemplateException, DbException {
                return true;
            }

            protected boolean sendVerificationEmail(FecruUser user, String code) throws IOException, TemplateException, DbException {
                return true;
            }

            protected boolean sendPasswordEmail(FecruUser user, String newPassword) throws IOException, TemplateException, DbException {
                return true;
            }

            protected FecruUser validateUser() {
                return tim;
            }
        };
        requestAction.setCaptchaResponse("hardToRead");
        requestAction.setUsernameOrEmail("tim");
        requestAction.doDefault();
        requestAction.validate();
        junit.framework.Assert.assertFalse((boolean)requestAction.hasErrors());
        junit.framework.Assert.assertEquals((String)"success", (String)requestAction.execute());
        ((LoginCookieDAO)Mockito.verify((Object)this.loginCookieDAO, (VerificationMode)Mockito.never())).deleteCookiesForUser((FecruUser)org.mockito.Matchers.anyObject());
        ((UserManager)Mockito.verify((Object)this.userManager)).requestPasswordReset("tim", "CAFEBABE");
        this.addPasswordResetRequest("tim");
        action.setCode("CAFEBABE");
        action.setUsernameOrEmail("tim@atlassian.com");
        action.validate();
        Assert.assertThat((Object)action.getActionErrors(), (Matcher)Matchers.empty());
        com.atlassian.crowd.model.user.User crowdUser = (com.atlassian.crowd.model.user.User)Mockito.mock(com.atlassian.crowd.model.user.User.class);
        Mockito.when((Object)this.crowdService.getUser("tim")).thenReturn((Object)crowdUser);
        junit.framework.Assert.assertEquals((String)"success", (String)action.execute());
        ((CrowdService)Mockito.verify((Object)this.crowdService)).updateUserCredential((User)crowdUser, "SECRET");
        ((UserManager)Mockito.verify((Object)this.userManager)).resetPassword((String)org.mockito.Matchers.eq((Object)"tim"), org.mockito.Matchers.anyString());
        ((LoginCookieDAO)Mockito.verify((Object)this.loginCookieDAO)).deleteCookiesForUser((FecruUser)org.mockito.Matchers.argThat((Matcher)new ArgumentMatcher<FecruUser>(){

            public boolean matches(Object user) {
                return user instanceof FecruUser && "tim".equals(((FecruUser)user).getUsername());
            }
        }));
    }

    public void assertErrors(String expectedErrorMessage, Collection actualErrorMessages) {
        this.assertErrors(new String[]{expectedErrorMessage}, actualErrorMessages);
    }

    public void assertErrors(String[] expectedErrorMessages, Collection actualErrorMessages) {
        junit.framework.Assert.assertEquals((String)"Incorrect number of error messages", (int)expectedErrorMessages.length, (int)actualErrorMessages.size());
        int i = 0;
        Iterator iterator = actualErrorMessages.iterator();
        while (iterator.hasNext()) {
            junit.framework.Assert.assertEquals((String)expectedErrorMessages[i], (String)((String)iterator.next()));
            ++i;
        }
    }

    private FecruUser addUser(String name) throws DbException {
        FecruUser user = (FecruUser)Mockito.mock(FecruUser.class);
        Mockito.when((Object)user.getUsername()).thenReturn((Object)name);
        this.userDAO.users.add(user);
        return user;
    }

    private void addPasswordResetRequest(String name, String code, long timestamp) throws DbException {
        FecruUser user = this.userDAO.getByUsername(name);
        Mockito.when((Object)user.getPasswordResetSRnd()).thenReturn((Object)code);
        Mockito.when((Object)user.getPasswordResetTimeStamp()).thenReturn((Object)timestamp);
    }

    private void addPasswordResetRequest(String name) throws DbException {
        this.addPasswordResetRequest(name, "CAFEBABE", System.currentTimeMillis());
    }

    private void addExpiredPasswordResetRequest(String name) throws DbException {
        this.addPasswordResetRequest(name, "CAFEBABE", System.currentTimeMillis() - 172800000L);
    }

    private class RequestPasswordResetActionUnderTest
    extends RequestPasswordResetAction {
        private RequestPasswordResetActionUnderTest() {
        }

        protected boolean isMailServerConfigured() {
            return true;
        }

        protected FecruUser getUserFromUsername(String username) throws DbException {
            return PasswordResetTest.this.userDAO.getByUsername(username);
        }

        protected String generateSecureRnd() {
            return "CAFEBABE";
        }

        protected void assignCaptchaId() {
            this.captchaId = "1337h4x0r5";
        }

        protected Boolean validateCaptchaResponse() {
            return Boolean.TRUE;
        }

        public boolean isCaptchaEnabled() {
            return true;
        }
    }

    private class PasswordResetActionUnderTest
    extends PasswordResetAction {
        public PasswordResetActionUnderTest() {
            this.setUserManager(this.userManager);
            this.setUserRepositoryPropertyManager(PasswordResetTest.this.userRepositoryPropertyManager);
        }

        protected boolean isMailServerConfigured() {
            return true;
        }

        protected FecruUser getUserFromUsername(String username) throws DbException {
            return PasswordResetTest.this.userDAO.getByUsername(username);
        }

        protected String generateSecureRnd() {
            return "CAFEBABE";
        }

        protected String generateNewPassword() {
            return "SECRET";
        }
    }
}

