/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.setup;

import com.cenqua.fisheye.config.AdminConfig;
import com.cenqua.fisheye.config.ConfigMockery;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.web.admin.actions.setup.PasswordAction;
import com.cenqua.fisheye.web.admin.actions.setup.SetupTestBase;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class PasswordActionTest
extends SetupTestBase {
    private PasswordAction action;

    @Before
    public void setUp() throws Exception {
        this.action = new PasswordAction();
        this.action.setApplicationLinkService(this.applicationLinkService);
    }

    @Test
    public void testValidatePasswords() {
        RootConfig config = ConfigMockery.mockRootConfig();
        this.action.setRootConfig(config);
        this.action.validate();
        Assert.assertEquals((Object)"Password is missing", (Object)this.fieldErrorFor(this.action, "password1"));
        this.action.clearErrorsAndMessages();
        this.action.setPassword1("blah");
        this.action.validate();
        Assert.assertEquals((Object)"Your admin password must be at least 6 characters, and preferably a mixture of numbers and letters", (Object)this.fieldErrorFor(this.action, "password1"));
        this.action.clearErrorsAndMessages();
        this.action.setPassword1("123");
        this.action.setPassword2("123");
        this.action.validate();
        Assert.assertEquals((Object)"Your admin password must be at least 6 characters, and preferably a mixture of numbers and letters", (Object)this.fieldErrorFor(this.action, "password1"));
        this.action.clearErrorsAndMessages();
        this.action.setPassword1("password");
        this.action.setPassword2("nomatch");
        this.action.validate();
        Assert.assertEquals((Object)"Passwords don't match", (Object)this.fieldErrorFor(this.action, "password1"));
        this.action.clearErrorsAndMessages();
        this.action.setPassword2("password");
        this.action.validate();
        Assert.assertEquals((long)0L, (long)this.action.getFieldErrors().size());
    }

    @Test
    public void testSavePassword() {
        RootConfig config = ConfigMockery.mockRootConfig();
        this.action.setRootConfig(config);
        String pass = "my password!";
        this.action.setPassword1("my password!");
        Assert.assertEquals((Object)"success", (Object)this.action.execute());
        ((AdminConfig)Mockito.verify((Object)config.getAdminConfig())).setAdminPassword("my password!");
    }

    private Object fieldErrorFor(PasswordAction action, String name) {
        List errors = (List)action.getFieldErrors().get(name);
        return errors != null && errors.size() > 0 ? errors.get(0) : null;
    }
}

