/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.setup;

import com.atlassian.fecru.license.LicenseManager;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.config.ConfigMockery;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.web.admin.actions.setup.LicenseAction;
import com.cenqua.fisheye.web.admin.actions.setup.SetupTestBase;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class LicenseActionTest
extends SetupTestBase {
    private LicenseManager licenseManager;
    private LicenseAction action;

    @Before
    public void setUp() throws Exception {
        this.licenseManager = (LicenseManager)Mockito.mock(LicenseManager.class);
        this.action = new LicenseAction(){

            public String getBuildDate() {
                return "2010-04-17";
            }

            protected LicenseManager getLicenseManager() {
                return LicenseActionTest.this.licenseManager;
            }
        };
        this.action.setApplicationLinkService(this.applicationLinkService);
    }

    @Test
    public void testWithExpiredEval() {
        RootConfig config = ConfigMockery.mockRootConfig();
        this.action.setRootConfig(config);
        this.action.setCrucibleLicense("AAABAQ0ODAoPeNp1kFFLwzAQx9/zKQI+dyTdFCkEHGmFQruKTJ/2cgvnFkzTkqSb+/a262ZV9PGO/\n/3ud3fz6DRdto7OGWUsub1PFozKdE1jxhlJ0Sun26AbK6TrlN4a3CQ0O4DpYOiSVVdv0VVvLx6dF\n5wxoi65GRecSIfnXAoBxYCM2Dzid0Q2NoAKK6hR2BaNaY4PEAx4r8HOVFNPmEIrtB7XpxbPcVmVZ\nfYs82VxpWQlaPMPZlIVwXVIzEh77W2HXkz6WRvQglWYfbTanb6pLgbVL5Gfp0acVG4HVvuRHh8R3\n/2U7r30AcellxPyVBR5eq3+3vbUObUHj78f9glxYY9UMCwCFAzay4b7n9SlCIhP1LAZEeABUw4cA\nhQDDraHaGPlPRYsp2xiOz+DCatWvw==X02d9");
        Assert.assertEquals((Object)"error", (Object)this.action.doSaveCrucible());
        List errors = (List)this.action.getFieldErrors().get("CrucibleLicense");
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertTrue((boolean)((String)errors.get(0)).startsWith("Upgrades for your license ended"));
    }

    @Test
    public void testWithValidCruLicense() throws IOException {
        RootConfig config = ConfigMockery.mockRootConfig();
        this.action.setRootConfig(config);
        this.action.setCrucibleLicense("qMqRmLENIjGEKbtAQbwVtoXVqNopDBekhJgDJubIwKdUIJ\nmi2K2Bt6jt>dPQ0JYUoUcHMb2KXb<MWDz<WhaHUfybkCt0\nmqOOWwRNQMMPQMNoqQQWuQonQnpNRmmMNRVSstXsSXTxSP\nWvtoTTwwuPMmnonnnmUUqmvrqmsummmmmUUqmvrqmsummm\nmmUU1qiXppfXkWGqvWCqaUUnmmmm");
        Assert.assertEquals((Object)"success", (Object)this.action.doSaveCrucible());
        ((LicenseManager)Mockito.verify((Object)this.licenseManager, (VerificationMode)Mockito.times((int)1))).updateLicenses((String)Matchers.isNull(String.class), (String)Matchers.eq((Object)"qMqRmLENIjGEKbtAQbwVtoXVqNopDBekhJgDJubIwKdUIJ\nmi2K2Bt6jt>dPQ0JYUoUcHMb2KXb<MWDz<WhaHUfybkCt0\nmqOOWwRNQMMPQMNoqQQWuQonQnpNRmmMNRVSstXsSXTxSP\nWvtoTTwwuPMmnonnnmUUqmvrqmsummmmmUUqmvrqmsummm\nmmUU1qiXppfXkWGqvWCqaUUnmmmm"));
    }

    @Test
    public void testWithValidFELicense() throws IOException {
        RootConfig config = ConfigMockery.mockRootConfig();
        this.action.setRootConfig(config);
        this.action.setFishEyeLicense("qpRopEjwRRsNNcldkLAJnDearOREObjJrOxwuRdaQHgsnkf\nmj2KhRwOjUSbPWZCt>0QzX3o2L05Ge<GJPJIAuLT8Oyt4Lz\nrrNoXXNqnrmrnNNMrmRTXPnPmqQRQnRPQqTxsVtVuVXXsOW\nVSrwssvXoNpqnnonmUUqmvrqmsummmmmUUqmvrqmsummmmm\nUU1qiXppfXkWGqvWCqaUUnmmmm");
        Assert.assertEquals((Object)"success", (Object)this.action.doSaveFishEye());
        ((LicenseManager)Mockito.verify((Object)this.licenseManager, (VerificationMode)Mockito.times((int)1))).updateLicenses((String)Matchers.eq((Object)"qpRopEjwRRsNNcldkLAJnDearOREObjJrOxwuRdaQHgsnkf\nmj2KhRwOjUSbPWZCt>0QzX3o2L05Ge<GJPJIAuLT8Oyt4Lz\nrrNoXXNqnrmrnNNMrmRTXPnPmqQRQnRPQqTxsVtVuVXXsOW\nVSrwssvXoNpqnnonmUUqmvrqmsummmmmUUqmvrqmsummmmm\nUU1qiXppfXkWGqvWCqaUUnmmmm"), (String)Matchers.isNull(String.class));
    }

    @Test
    public void testWithValidFeCRULicense() throws IOException {
        RootConfig config = ConfigMockery.mockRootConfig();
        this.action.setRootConfig(config);
        this.action.setFishEyeLicense("qpRopEjwRRsNNcldkLAJnDearOREObjJrOxwuRdaQHgsnkf\nmj2KhRwOjUSbPWZCt>0QzX3o2L05Ge<GJPJIAuLT8Oyt4Lz\nrrNoXXNqnrmrnNNMrmRTXPnPmqQRQnRPQqTxsVtVuVXXsOW\nVSrwssvXoNpqnnonmUUqmvrqmsummmmmUUqmvrqmsummmmm\nUU1qiXppfXkWGqvWCqaUUnmmmm");
        this.action.setCrucibleLicense("qMqRmLENIjGEKbtAQbwVtoXVqNopDBekhJgDJubIwKdUIJ\nmi2K2Bt6jt>dPQ0JYUoUcHMb2KXb<MWDz<WhaHUfybkCt0\nmqOOWwRNQMMPQMNoqQQWuQonQnpNRmmMNRVSstXsSXTxSP\nWvtoTTwwuPMmnonnnmUUqmvrqmsummmmmUUqmvrqmsummm\nmmUU1qiXppfXkWGqvWCqaUUnmmmm");
        Assert.assertEquals((Object)"success", (Object)this.action.doSaveFishEye());
        ((LicenseManager)Mockito.verify((Object)this.licenseManager, (VerificationMode)Mockito.times((int)1))).updateLicenses((String)Matchers.eq((Object)"qpRopEjwRRsNNcldkLAJnDearOREObjJrOxwuRdaQHgsnkf\nmj2KhRwOjUSbPWZCt>0QzX3o2L05Ge<GJPJIAuLT8Oyt4Lz\nrrNoXXNqnrmrnNNMrmRTXPnPmqQRQnRPQqTxsVtVuVXXsOW\nVSrwssvXoNpqnnonmUUqmvrqmsummmmmUUqmvrqmsummmmm\nUU1qiXppfXkWGqvWCqaUUnmmmm"), (String)Matchers.eq((Object)"qMqRmLENIjGEKbtAQbwVtoXVqNopDBekhJgDJubIwKdUIJ\nmi2K2Bt6jt>dPQ0JYUoUcHMb2KXb<MWDz<WhaHUfybkCt0\nmqOOWwRNQMMPQMNoqQQWuQonQnpNRmmMNRVSstXsSXTxSP\nWvtoTTwwuPMmnonnnmUUqmvrqmsummmmmUUqmvrqmsummm\nmmUU1qiXppfXkWGqvWCqaUUnmmmm"));
    }

    @Test
    public void testMissingLicense() {
        RootConfig config = ConfigMockery.mockRootConfig();
        this.action.setRootConfig(config);
        this.action.setFishEyeLicense(null);
        Assert.assertEquals((Object)"error", (Object)this.action.doSaveFishEye());
        List errors = (List)this.action.getFieldErrors().get("FishEyeLicense");
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertEquals((Object)"License is not set.", errors.get(0));
    }

    @Test
    public void testLicenseRequest() {
        FisheyeVersionInfo version = (FisheyeVersionInfo)Mockito.mock(FisheyeVersionInfo.class);
        Mockito.when((Object)version.getSid()).thenReturn((Object)"MY-TEST-SID");
        Mockito.when((Object)version.getReleaseNum()).thenReturn((Object)"RELEASE-NUM");
        Mockito.when((Object)version.getBuildNumber()).thenReturn((Object)"BUILD-NUM");
        String request = this.action.makeLicenseUrl("FishEye", version, "http://localhost:6060/setup/saveFishEyeLicense.do");
        Assert.assertEquals((Object)"http://www.atlassian.com/ex/GenerateLicense.jspa?utm_nooverride=1&ref=prod&product=FishEye&version=RELEASE-NUM&build=BUILD-NUM&sid=MY-TEST-SID&licensefieldname=FishEyeLicense&callback=http%3A//localhost%3A6060/setup/saveFishEyeLicense.do", (Object)request);
    }
}

