/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.extras.api.ProductLicense;
import com.atlassian.fecru.license.LicenseManager;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.web.admin.actions.SystemInfoAction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SystemInfoActionTest {
    private SystemInfoAction systemInfoAction;
    @Mock
    private LicenseManager licenseManager;
    @Mock
    private ProductLicense productLicense;
    @Mock
    private LicenseInfo licenseInfo;

    @Before
    public void setUp() throws Exception {
        this.systemInfoAction = new SystemInfoAction(this.licenseManager);
        Mockito.when((Object)this.licenseManager.getLicenseInfo()).thenReturn((Object)this.licenseInfo);
    }

    @Test
    public void testAvailableFeSeats() throws Exception {
        Mockito.when((Object)this.licenseInfo.getFisheyeLicense()).thenReturn((Object)this.productLicense);
        Mockito.when((Object)this.productLicense.getMaximumNumberOfUsers()).thenReturn((Object)100);
        Mockito.when((Object)this.licenseManager.getFishEyeUsersCount()).thenReturn((Object)80);
        int availableFeSeats = this.systemInfoAction.getAvailableFeSeats();
        Assert.assertEquals((long)20L, (long)availableFeSeats);
    }

    @Test
    public void testAvailableCruSeats() throws Exception {
        Mockito.when((Object)this.licenseInfo.getCrucibleLicense()).thenReturn((Object)this.productLicense);
        Mockito.when((Object)this.productLicense.getMaximumNumberOfUsers()).thenReturn((Object)200);
        Mockito.when((Object)this.licenseManager.getCrucibleUsersCount()).thenReturn((Object)80);
        int availableFeSeats = this.systemInfoAction.getAvailableCruSeats();
        Assert.assertEquals((long)120L, (long)availableFeSeats);
    }
}

