/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.config.RootConfigRule;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.actions.LoginAction;
import com.cenqua.fisheye.web.admin.interceptors.LoginInterceptor;
import com.cenqua.fisheye.web.util.SafeRedirectChecker;
import com.google.common.collect.ImmutableMap;
import com.google.gwt.dev.util.collect.HashMap;
import com.opensymphony.xwork.ActionContext;
import java.lang.reflect.Field;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class LoginActionTest {
    private static final String ADMIN_PASSWORD = "password";
    private static final String URL_1 = "http://google.com";
    private static final String URL_2 = "http://atlassian.com";
    @Rule
    public RootConfigRule rootConfigRule = new RootConfigRule();
    private LoginAction action;
    private Map<String, Object> session;

    @Before
    public void setUp() throws NoSuchFieldException, IllegalAccessException {
        this.action = new LoginAction();
        Mockito.when((Object)this.rootConfigRule.getRootConfig().getAdminConfig().isAdminEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.rootConfigRule.getRootConfig().getAdminConfig().verifyAdminPassword(ADMIN_PASSWORD)).thenReturn((Object)true);
        this.session = new HashMap();
        ActionContext.setContext((ActionContext)new ActionContext((Map)ImmutableMap.of((Object)"com.opensymphony.xwork.ActionContext.session", this.session)));
        this.setUpChecker();
        this.setUpUserManager();
    }

    private void setUpChecker() throws IllegalAccessException, NoSuchFieldException {
        SafeRedirectChecker checker = (SafeRedirectChecker)Mockito.mock(SafeRedirectChecker.class);
        Field redirectCheckerField = this.action.getClass().getDeclaredField("safeRedirectChecker");
        redirectCheckerField.setAccessible(true);
        redirectCheckerField.set(this.action, checker);
        Mockito.when((Object)checker.canRedirectTo((String)Matchers.any())).thenReturn((Object)true);
    }

    private void setUpUserManager() throws IllegalAccessException, NoSuchFieldException {
        UserManager userManager = (UserManager)Mockito.mock(UserManager.class);
        Field userManagerField = this.action.getClass().getDeclaredField("userManager");
        userManagerField.setAccessible(true);
        userManagerField.set(this.action, userManager);
        Mockito.when((Object)userManager.hasSysAdminPrivileges((HttpServletRequest)Matchers.any(HttpServletRequest.class))).thenReturn((Object)false);
    }

    private void setSessionReturnURI(String returnURI) {
        this.session.put(LoginInterceptor.SUCCESS_URL_KEY, URL_2);
    }

    @Test
    public void testReturnURLFromParameterHasPrecedenceOverTheOneFromSession() throws Exception {
        this.action.setAdminPassword(ADMIN_PASSWORD);
        this.action.setOrigUrl(URL_1);
        this.setSessionReturnURI(URL_2);
        this.action.execute();
        Assert.assertEquals((Object)URL_1, (Object)this.action.getSuccessURL());
    }

    @Test
    public void testReturnURLFromSessionUsedIfTheOneFromParametersIsMissing() throws Exception {
        this.action.setAdminPassword(ADMIN_PASSWORD);
        this.action.setOrigUrl("");
        this.setSessionReturnURI(URL_2);
        this.action.execute();
        Assert.assertEquals((Object)URL_2, (Object)this.action.getSuccessURL());
    }

    @Test
    public void testReturnUrlFromParameterHasPrecedenceOverTheOneFromSessionOnLoginPage() throws Exception {
        this.action.setOrigUrl(URL_1);
        this.setSessionReturnURI(URL_2);
        this.action.doDefault();
        Assert.assertEquals((Object)URL_1, (Object)this.action.getSuccessURL());
    }

    @Test
    public void testReturnUrlFromSessionOnLoginPage() throws Exception {
        this.action.setOrigUrl("");
        this.setSessionReturnURI(URL_2);
        this.action.doDefault();
        Assert.assertEquals((Object)URL_2, (Object)this.action.getSuccessURL());
    }
}

