/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.web.admin.actions.HtmlTesterLayout;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import junit.framework.Assert;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class HtmlTesterLayoutTest {
    private static final String MESSAGE = "<strong>test log message</strong>";
    private final Logger logger = Logger.getLogger(this.getClass());
    private WriterAppender appender;
    private StringWriter writer;

    @Before
    public void setUp() throws Exception {
        NDC.clear();
        this.writer = new StringWriter();
        this.appender = new WriterAppender();
        this.appender.setThreshold((Priority)Level.ALL);
        this.appender.setImmediateFlush(true);
        this.appender.setWriter((Writer)this.writer);
        this.logger.addAppender((Appender)this.appender);
    }

    private void setupLayout(Layout layout) {
        this.appender.setLayout(layout);
    }

    @After
    public void tearDown() throws Exception {
        this.logger.removeAppender((Appender)this.appender);
    }

    @Test
    public void testFormatDefaultStyle() {
        String ndc = "context";
        this.setupLayout((Layout)new HtmlTesterLayout("context"));
        NDC.push((String)"context");
        this.logger.info((Object)MESSAGE);
        Assert.assertEquals((String)("<p style=\"" + (String)HtmlTesterLayout.getDefaultStyle().get(Level.INFO) + "\">" + MESSAGE + "</p>"), (String)this.writer.toString());
    }

    @Test
    public void testFormatCustomStyle() {
        String ndc = "context";
        String style = "color: red;";
        Map<Level, String> styles = Collections.singletonMap(Level.INFO, "color: red;");
        this.setupLayout((Layout)new HtmlTesterLayout(styles, "context"));
        NDC.push((String)"context");
        this.logger.info((Object)MESSAGE);
        Assert.assertEquals((String)"<p style=\"color: red;\"><strong>test log message</strong></p>", (String)this.writer.toString());
    }

    @Test
    public void testFormatError() {
        String ndc = "context";
        String style = "color: red;";
        Map<Level, String> styles = Collections.singletonMap(Level.ERROR, "color: red;");
        this.setupLayout((Layout)new HtmlTesterLayout(styles, "context"));
        NDC.push((String)"context");
        RuntimeException error = new RuntimeException("error");
        this.logger.error((Object)MESSAGE, (Throwable)error);
        String expected = "<p style=\"color: red;\"><strong>test log message</strong><br/>" + error.getMessage() + "(<br/>at [a-zA-Z0-9\\.\\_]+\\((Native Method|[a-zA-Z0-9\\$]+\\.java:[0-9]+)\\)){0,5}" + "</p>";
        String actual = this.writer.toString();
        Assert.assertTrue((String)("\nexpected: " + expected + "\nactual:   " + actual), (boolean)actual.matches(expected));
    }

    @Test
    public void testFormatWithHTMLEscape() {
        String ndc = "context";
        String style = "color: red;";
        Map<Level, String> styles = Collections.singletonMap(Level.INFO, "color: red;");
        this.setupLayout((Layout)new HtmlTesterLayout(styles, "context", true));
        NDC.push((String)"context");
        this.logger.info((Object)MESSAGE);
        Assert.assertEquals((String)("<p style=\"color: red;\">" + StringEscapeUtils.escapeHtml((String)MESSAGE) + "</p>"), (String)this.writer.toString());
    }

    @Test
    public void testFormatNullContext() throws Exception {
        this.setupLayout((Layout)new HtmlTesterLayout("context"));
        NDC.push(null);
        this.logger.info((Object)"testinfo");
        Assert.assertEquals((String)"", (String)this.writer.toString());
    }

    @Test
    public void testFormatDifferentContext() throws Exception {
        this.setupLayout((Layout)new HtmlTesterLayout("oldcontext"));
        NDC.push((String)"newcontext");
        this.logger.info((Object)"testinfo");
        Assert.assertEquals((String)"", (String)this.writer.toString());
    }
}

