/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.extras.common.LicenseException;
import com.atlassian.fecru.license.LicenseManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.LicenseType;
import com.cenqua.fisheye.web.admin.actions.EditLicenseAction;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class EditLicenseActionTest {
    private static final String SUCCESS = "success";
    private static final String INPUT = "input";
    private RootConfig rootConfig;
    private LicenseType configuredLicence;
    private LicenseManager licenseManager;

    @Before
    public void setUp() {
        this.rootConfig = (RootConfig)Mockito.mock(RootConfig.class);
        this.licenseManager = (LicenseManager)Mockito.mock(LicenseManager.class);
        ConfigDocument dummy = ConfigDocument.Factory.newInstance();
        ConfigDocument.Config config = dummy.addNewConfig();
        this.configuredLicence = config.addNewLicense();
        Mockito.when((Object)this.rootConfig.getConfig()).thenReturn((Object)config);
        this.rootConfig.setConfig(dummy);
    }

    @Test
    public void testEmptyConfigLicense() throws Exception {
        EditLicenseAction action = this.getEditLicenseAction();
        action.validate();
        Map errors = action.getFieldErrors();
        Assert.assertTrue((String)"Empty Licence is valid if not useful", (boolean)errors.isEmpty());
        action = new EditLicenseAction(this.rootConfig, this.licenseManager);
        action.doDefault();
        Assert.assertFalse((String)"Empty licence is not considered Crucible Eval", (boolean)action.isCruEvalOnly());
    }

    @Test
    public void testFishEyeEvalTerminated() {
        EditLicenseAction action = this.getEditLicenseAction();
        action.setFeLicense("oQRoXxFbidCOIPBMcvpWPonqOopfOseDkxJumwRSCGHnXDF\nmj2KnaI4pzCWZx7fvqSnaz3>2L05UMjv<mn>CrCy0VMvOj2\nRqRnxWnrMOPQroQOmMqxVRrRooPPOPmQoQtstwSTtXxTTtv\nprQnopmUUnnuqtstommmmmUUnnuqtstommmmmUU1qiXppfX\nkUUnmm");
        action.validate();
        Map errors = action.getFieldErrors();
        Assert.assertTrue((String)"Terminated License should be invalid", (errors.size() == 1 && errors.containsKey("feLicense") && errors.get("feLicense").toString().contains("terminated") ? 1 : 0) != 0);
    }

    @Test
    public void testCrucibleEvalTerminated() {
        EditLicenseAction action = this.getEditLicenseAction();
        action.setCruLicense("nOnmmHxExnLDwaOGsEhRGCgjpnxUoUIMGjmqVgVwFvugdh\nmi2K<TZmRgd2lEYIupqfwaOr2KVGyH>C3PXkNYyQM8TXR6\nNmOMUVnNoNPPrnmOQoPutNOpONMrQoPpNRWWTWWtWUvwsv\numRPnnpmUUnnuqtstommmmmUUnnuqtstommmmmUU1qiXpp\nfXkUUnmm");
        action.validate();
        Map errors = action.getFieldErrors();
        Assert.assertTrue((String)"Terminated License is invalid", (errors.containsKey("cruLicense") && errors.get("cruLicense").toString().contains("terminated") ? 1 : 0) != 0);
    }

    @Test
    public void testIncorrectProducts() {
        EditLicenseAction action = this.getEditLicenseAction();
        action.setFeLicense("AAABkw0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyrMR1akBAHIkpXMRW4EiHtMmBptc2E4kU+HCqf1/GD8ANkiuXs9/M7LfSI0z8BpIhxKPx5WAcx1CVGSTxYEjW0m6xw+hOClQWy67FNCtmM7bIppM7MvfNEk2xriwamw5ikmnluHBz3mDKl9roN/sqr7mrubWSq0johtx7I7bcYs4dpu8UGl/RZEjOGHv9Gec4Yn9babq9zqtaNtLh6oRkMy7rL5mf5PjIeECzQzPN0xs2YvQy/53Q78WvEf158eOK9Hq9eVHS22JB7xdFXmXltJjT6oGFQZoZDJZWsOzAbRGODGBK6BUaaI1+QeHgz9a59mnc72909J+7fn1QUDwoniPINSjtYCWtM3LpHYbN0oLTILx1ugl1RyQkVg4VV+K8mSROTo0Gc9mCTUqW05vHd6df1XO0HMJX6lXpN0UKs+FKWu6kVunk9Jnso4anj7c79RsOIXeYOuOR5GiFke1+w22Ysw6fxpDpJrgXkteE7XjtD4Q1ry2Sf/fM3YowLQIUVv9q4uFYR6m3CfQkgP2hGg5HRtgCFQCT/yGXA8mPLzsy+9U54BdMKG/zvg==X02jj");
        action.setCruLicense("AAABkw0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyrMR1akBAHIkpXMRW4EiHtMmBptc2E4kU+HCqf1/GD8ANkiuXs9/M7LfSI0z8BpIhxKPx5WAcx1CVGSTxYEjW0m6xw+hOClQWy67FNCtmM7bIppM7MvfNEk2xriwamw5ikmnluHBz3mDKl9roN/sqr7mrubWSq0johtx7I7bcYs4dpu8UGl/RZEjOGHv9Gec4Yn9babq9zqtaNtLh6oRkMy7rL5mf5PjIeECzQzPN0xs2YvQy/53Q78WvEf158eOK9Hq9eVHS22JB7xdFXmXltJjT6oGFQZoZDJZWsOzAbRGODGBK6BUaaI1+QeHgz9a59mnc72909J+7fn1QUDwoniPINSjtYCWtM3LpHYbN0oLTILx1ugl1RyQkVg4VV+K8mSROTo0Gc9mCTUqW05vHd6df1XO0HMJX6lXpN0UKs+FKWu6kVunk9Jnso4anj7c79RsOIXeYOuOR5GiFke1+w22Ysw6fxpDpJrgXkteE7XjtD4Q1ry2Sf/fM3YowLQIUVv9q4uFYR6m3CfQkgP2hGg5HRtgCFQCT/yGXA8mPLzsy+9U54BdMKG/zvg==X02jj");
        action.validate();
        Map errors = action.getFieldErrors();
        Assert.assertTrue((String)"Incorrect License should be invalid", (errors.containsKey("cruLicense") && errors.get("cruLicense").toString().contains("invalid") ? 1 : 0) != 0);
        action.setFeLicense("AAABkA0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyotp1akBAHYotXMRW4EiHtumBojc2G4kU+HDqf1/GD9QNmvPuzHw7+64KCLOwgWwM6WQ6Gk1HKdQVgyy9GpNl6Bq05WPt0Lr8KiXMaC+kX4oOc9EYa57dk/okfCucU0In0nTkLli5FQ4L4TF/saHpNc3G5FZJ1A6rfY8HPSsXC75i89ntecR/98ruD7qgW9Upj+tzJF8I1b6ZeY92h3Ze5Dd8wumo+J7RD+XXCf3y/uM1kTZI1bSYXBBcpv9v/ppwMBgsy4p+Llf0blUWNavm5ZLW9zwOcmYxMq+h2YPfIpxsgGtp1miht+YXSg8/tt73D9PhcGOSf/CH7VFB8aj4mUBhQBsPa+W8VU3wGJ2VA29ABudNF/+RkFiJ9qiFlpfVZWl2rjzCsRWfVbygN99eSN/q74QcC6z1kzbPmpR2I7Rywiuj89l5+W9X8SVqh7m3Acnh/rj3+uMFOmlVf7BgJ+HDFJjpIr9UoiV8J9pwzHgUrUPyB37u3yEwLAIUR/jwO+7JuGUuC0m+noQv2AQ8nScCFBqhmxM/enSI22QiZSrT8F3qbyggX02jb");
        action.setCruLicense("AAABkA0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyotp1akBAHYotXMRW4EiHtumBojc2G4kU+HDqf1/GD9QNmvPuzHw7+64KCLOwgWwM6WQ6Gk1HKdQVgyy9GpNl6Bq05WPt0Lr8KiXMaC+kX4oOc9EYa57dk/okfCucU0In0nTkLli5FQ4L4TF/saHpNc3G5FZJ1A6rfY8HPSsXC75i89ntecR/98ruD7qgW9Upj+tzJF8I1b6ZeY92h3Ze5Dd8wumo+J7RD+XXCf3y/uM1kTZI1bSYXBBcpv9v/ppwMBgsy4p+Llf0blUWNavm5ZLW9zwOcmYxMq+h2YPfIpxsgGtp1miht+YXSg8/tt73D9PhcGOSf/CH7VFB8aj4mUBhQBsPa+W8VU3wGJ2VA29ABudNF/+RkFiJ9qiFlpfVZWl2rjzCsRWfVbygN99eSN/q74QcC6z1kzbPmpR2I7Rywiuj89l5+W9X8SVqh7m3Acnh/rj3+uMFOmlVf7BgJ+HDFJjpIr9UoiV8J9pwzHgUrUPyB37u3yEwLAIUR/jwO+7JuGUuC0m+noQv2AQ8nScCFBqhmxM/enSI22QiZSrT8F3qbyggX02jb");
        action.validate();
        errors = action.getFieldErrors();
        Assert.assertTrue((String)"Incorrect License should be invalid", (errors.containsKey("feLicense") && errors.get("feLicense").toString().contains("invalid") ? 1 : 0) != 0);
    }

    @Test
    public void testBogus() {
        EditLicenseAction action = this.getEditLicenseAction();
        action.setFeLicense("Not a licence");
        action.validate();
        Map errors = action.getFieldErrors();
        Assert.assertTrue((String)"Bogus string should be invalid", (errors.containsKey("feLicense") && errors.get("feLicense").toString().contains("invalid") ? 1 : 0) != 0);
        action = this.getEditLicenseAction();
        action.setCruLicense("Not a licence either");
        action.validate();
        errors = action.getFieldErrors();
        Assert.assertTrue((String)"Bogus License should be invalid", (errors.containsKey("cruLicense") && errors.get("cruLicense").toString().contains("invalid") ? 1 : 0) != 0);
    }

    @Test
    public void testCruEvalConfig() throws Exception {
        this.configuredLicence.setCrucible("nOnmmHxExnLDwaOGsEhRGCgjpnxUoUIMGjmqVgVwFvugdh\nmi2K<TZmRgd2lEYIupqfwaOr2KVGyH>C3PXkNYyQM8TXR6\nNmOMUVnNoNPPrnmOQoPutNOpONMrQoPpNRWWTWWtWUvwsv\numRPnnpmUUnnuqtstommmmmUUnnuqtstommmmmUU1qiXpp\nfXkUUnmm");
        EditLicenseAction action = this.getEditLicenseAction();
        action.doDefault();
        Assert.assertTrue((String)"Expired eval should still warn about CRU eval->commercial", (boolean)action.isCruEvalOnly());
    }

    @Test
    public void testExecuteCallsLicenseManager() throws Exception {
        String cruLicense = "someCruLicense";
        String feLicense = "someFeLicense";
        EditLicenseAction action = this.getEditLicenseAction();
        action.setCruLicense("someCruLicense");
        action.setFeLicense("someFeLicense");
        String result = action.execute();
        Assert.assertEquals((String)"Given action should be successes", (Object)SUCCESS, (Object)result);
        ((LicenseManager)Mockito.verify((Object)this.licenseManager, (VerificationMode)Mockito.times((int)1))).updateLicenses((String)Matchers.eq((Object)"someFeLicense"), (String)Matchers.eq((Object)"someCruLicense"));
    }

    @Test
    public void testExecuteLicenseExceptionIsThrown() throws Exception {
        String cruLicense = "someCruLicense";
        String feLicense = "someFeLicense";
        EditLicenseAction action = this.getEditLicenseAction();
        action.setCruLicense("someCruLicense");
        action.setFeLicense("someFeLicense");
        ((LicenseManager)Mockito.doThrow(LicenseException.class).when((Object)this.licenseManager)).updateLicenses(Matchers.anyString(), Matchers.anyString());
        String result = action.execute();
        Assert.assertEquals((String)"On LicenseException action shouldn't be successful", (Object)INPUT, (Object)result);
    }

    private EditLicenseAction getEditLicenseAction() {
        return new EditLicenseAction(this.rootConfig, this.licenseManager);
    }
}

