/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fisheye.functest.util.WebTesterFactory;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.cenqua.fisheye.web.WebServer;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.xmlbeans.XmlException;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.RestoreSystemProperties;

public final class WebServerTest {
    private final File appLocation = new File(FisheyeTestEnv.WORKSPACE_DIR, "/output/dist");
    private final File instanceDir = new File(FisheyeTestEnv.WORKSPACE_DIR, "/output/tmp/sanity1");
    private final File tmpDir = new File(FisheyeTestEnv.WORKSPACE_DIR, "/output/tmp");
    private HttpClient httpClient;
    private WebServer server;
    private File oldAppHome;
    private File oldInstanceDir;
    @Rule
    public final RestoreSystemProperties restoreSystemProperties = new RestoreSystemProperties();

    @Before
    public void setUp() throws Exception {
        this.httpClient = new HttpClient();
        this.oldAppHome = AppConfig.getAppHome();
        this.oldInstanceDir = AppConfig.getInstanceDir();
    }

    @After
    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        AppConfig.overrideAppHome((File)this.oldAppHome, (File)this.oldInstanceDir);
    }

    @Test
    public void testSslProxyPassing() throws Exception {
        WebTesterFactory.setupSSL((String)"https", (int)6060);
        this.startupWebServer("/com/cenqua/fisheye/web/ssl-proxy-passing-config.xml");
        this.assertLocationHeader(String.format("https://proxy_host:%d%s/content/", 6060, this.getContext()), String.format("https://localhost:%d%s/content", 6060, this.getContext()));
    }

    @Test
    public void testHttpProxyPassing() throws Exception {
        this.startupWebServer("/com/cenqua/fisheye/web/http-proxy-passing-config.xml");
        this.assertLocationHeader(String.format("http://proxy_host:%d%s/content/", 6060, this.getContext()), String.format("http://localhost:%d%s/content", 6060, this.getContext()));
    }

    @Test
    public void testObfuscatedPasswords() throws Exception {
        junit.framework.Assert.assertEquals((String)"password", (String)new Password("OBF:1v2j1uum1xtv1zej1zer1xtn1uvk1v1v").toString());
        junit.framework.Assert.assertEquals((String)"password", (String)new Password("password").toString());
        junit.framework.Assert.assertEquals((String)"", (String)new Password("").toString());
        junit.framework.Assert.assertEquals((String)" ", (String)new Password(" ").toString());
        junit.framework.Assert.assertEquals(null, (String)new Password(null).toString());
    }

    @Test
    public void testPassesCipherAndProtocolConfigToJetty() throws Exception {
        WebTesterFactory.setupSSL((String)"https", (int)6060);
        this.startupWebServer("/com/cenqua/fisheye/web/ssl-suites-and-ciphers-config.xml");
        SslSocketConnector connector = (SslSocketConnector)Iterables.find(Arrays.asList(this.server.getServer().getConnectors()), (Predicate)Predicates.instanceOf(SslSocketConnector.class));
        SslContextFactory sslContextFactory = connector.getSslContextFactory();
        Assert.assertThat((Object)sslContextFactory.getIncludeProtocols(), (Matcher)Matchers.array((Matcher[])new Matcher[]{Matchers.equalTo((Object)"TLSv1")}));
        Assert.assertThat((Object)sslContextFactory.getExcludeProtocols(), (Matcher)Matchers.array((Matcher[])new Matcher[]{Matchers.equalTo((Object)"SSLv3")}));
        Assert.assertThat((Object)sslContextFactory.getIncludeCipherSuites(), (Matcher)Matchers.array((Matcher[])new Matcher[]{Matchers.equalTo((Object)"TLS_RSA_WITH_AES_256_CBC_SHA")}));
        Assert.assertThat((Object)sslContextFactory.getExcludeCipherSuites(), (Matcher)Matchers.array((Matcher[])new Matcher[]{Matchers.equalTo((Object)"TLS_RSA_WITH_AES_128_CBC_SHA")}));
    }

    @Test
    public void testCustomContentDir() throws Exception {
        System.setProperty("fecru.content.dir.override", "");
        this.startupWebServer("/com/cenqua/fisheye/web/ssl-proxy-passing-config.xml");
        String customContentDir = this.server.getCustomContentDir().toString();
        String expectedContentDir = new File(this.instanceDir, "content").getCanonicalPath();
        Assert.assertEquals((String)"Custom content directory should be located inside the instance directory", (Object)customContentDir, (Object)expectedContentDir);
    }

    @Test
    public void testCustomContentDirOverride() throws Exception {
        String contentPath = "path/to/../the/../new_content";
        System.setProperty("fecru.content.dir.override", contentPath);
        this.startupWebServer("/com/cenqua/fisheye/web/ssl-proxy-passing-config.xml");
        String customContentDir = this.server.getCustomContentDir().toString();
        String expectedContentDir = new File(FisheyeTestEnv.WORKSPACE_DIR, contentPath).getCanonicalPath();
        Assert.assertEquals((String)"Custom content directory should point to the overridden one", (Object)customContentDir, (Object)expectedContentDir);
    }

    private void assertLocationHeader(String expectedLocationHeader, String url) throws IOException, XmlException {
        GetMethod get = this.makeGetMethod(url);
        int status = this.httpClient.executeMethod((HttpMethod)get);
        junit.framework.Assert.assertEquals((int)302, (int)status);
        junit.framework.Assert.assertEquals((String)("headers :" + Arrays.toString(get.getResponseHeaders())), (String)expectedLocationHeader, (String)get.getResponseHeader("Location").getValue());
    }

    private void startupWebServer(String configFile) throws Exception {
        try {
            AppConfig.overrideAppHome((File)this.appLocation, (File)this.instanceDir);
            RootConfig rootConfig = this.loadRootConfig(configFile);
            this.server = new WebServer(rootConfig, this.appLocation, this.instanceDir, this.tmpDir);
            this.server.start();
        }
        catch (Exception e) {
            this.doFail(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RootConfig loadRootConfig(String configFile) throws ConfigException, IOException, XmlException {
        RootConfig rootConfig;
        InputStream input = null;
        try {
            input = this.getClass().getResourceAsStream(configFile);
            ConfigDocument configDoc = TestFishEyeInstances.loadConfigDocumentFromStream(input);
            RootConfig rootConfig2 = new RootConfig();
            rootConfig2.load(configDoc);
            rootConfig = rootConfig2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
        return rootConfig;
    }

    private GetMethod makeGetMethod(String uri) throws IOException, XmlException {
        GetMethod method = new GetMethod(uri);
        method.setFollowRedirects(false);
        return method;
    }

    private String getContext() throws IOException, XmlException {
        if (System.getProperty("web.context") != null) {
            return System.getProperty("web.context");
        }
        return "/foo";
    }

    private void doFail(Exception e) throws Exception {
        try {
            e.printStackTrace(System.err);
            junit.framework.Assert.fail((String)("problem while starting server: " + e.getMessage()));
        }
        finally {
            this.tearDown();
        }
    }
}

