/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.rep.DummyFileRevision;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.web.WaybackSpec;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class WaybackSpecTest {
    @Test
    public void testMatchesDates() throws Exception {
        final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DummyFileRevision fileRev = new DummyFileRevision(){
            private final Date date;
            {
                this.date = sdf.parse("2010-09-02");
            }

            @Override
            public long getDate() {
                return this.date.getTime();
            }
        };
        WaybackSpec wb = new WaybackSpec();
        this.setWaybackDateConstraints(wb, "2010-09-01", null);
        Assert.assertTrue((String)"Revision after date", (boolean)wb.matchesRevision((FileRevision)fileRev, false));
        this.setWaybackDateConstraints(wb, null, "2010-09-03");
        Assert.assertTrue((String)"Revision before date", (boolean)wb.matchesRevision((FileRevision)fileRev, false));
        this.setWaybackDateConstraints(wb, "2010-09-01", "2010-09-03");
        Assert.assertTrue((String)"Revision between dates", (boolean)wb.matchesRevision((FileRevision)fileRev, false));
        this.setWaybackDateConstraints(wb, "2010-08-01", "2010-08-03");
        Assert.assertFalse((String)"Revision not between dates", (boolean)wb.matchesRevision((FileRevision)fileRev, false));
    }

    private void setWaybackDateConstraints(WaybackSpec wb, String start, String end) throws Exception {
        wb.setStartDateStr(null);
        wb.setStartTime(0L);
        wb.setEndDateStr(null);
        wb.setEndTime(0L);
        WaybackSpec.parseDate((WaybackSpec)wb, (String)start, (boolean)true);
        WaybackSpec.parseDate((WaybackSpec)wb, (String)end, (boolean)false);
    }

    @Test
    public void testWaybackDateParsing() {
        WaybackSpec wb = new WaybackSpec();
        boolean parsed = WaybackSpec.parseDate((WaybackSpec)wb, (String)"2010-09-01", (boolean)true);
        Assert.assertTrue((String)"Date was parsed correctly", (boolean)parsed);
        this.assertTimeValue(wb.getStartTime(), 2010, 9, 1, 0, 0, 0);
        parsed = WaybackSpec.parseDate((WaybackSpec)wb, (String)"2010-09-01", (boolean)false);
        Assert.assertTrue((String)"Date was parsed correctly", (boolean)parsed);
        this.assertTimeValue(wb.getEndTime(), 2010, 9, 1, 23, 59, 59);
        parsed = WaybackSpec.parseDate((WaybackSpec)wb, (String)"2010-09-01T00:00:00", (boolean)true);
        Assert.assertTrue((String)"Date was parsed correctly", (boolean)parsed);
        this.assertTimeValue(wb.getStartTime(), 2010, 9, 1, 0, 0, 0);
        parsed = WaybackSpec.parseDate((WaybackSpec)wb, (String)"2010-09-01T00:00:00", (boolean)false);
        Assert.assertTrue((String)"Date was parsed correctly", (boolean)parsed);
        this.assertTimeValue(wb.getEndTime(), 2010, 9, 1, 0, 0, 0);
        parsed = WaybackSpec.parseDate((WaybackSpec)wb, (String)"2012-01-31T11:42:09", (boolean)true);
        Assert.assertTrue((String)"Date was parsed correctly", (boolean)parsed);
        this.assertTimeValue(wb.getStartTime(), 2012, 1, 31, 11, 42, 9);
        parsed = WaybackSpec.parseDate((WaybackSpec)wb, (String)"1990-12-7T19:30:49", (boolean)true);
        Assert.assertTrue((String)"Date was parsed correctly", (boolean)parsed);
        this.assertTimeValue(wb.getStartTime(), 1990, 12, 7, 19, 30, 49);
    }

    private void assertTimeValue(long time, int year, int month, int date, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        Assert.assertEquals((String)"Year is equal", (int)year, (int)c.get(1));
        Assert.assertEquals((String)"Month is equal", (int)month, (int)(c.get(2) + 1));
        Assert.assertEquals((String)"Date is equal", (int)date, (int)c.get(5));
        Assert.assertEquals((String)"Hour is equal", (int)hour, (int)c.get(11));
        Assert.assertEquals((String)"Minute is equal", (int)minute, (int)c.get(12));
        Assert.assertEquals((String)"Second is equal", (int)second, (int)c.get(13));
    }

    @Test
    public void testMatchesCommentText() throws Exception {
        DummyFileRevision fileRev = new DummyFileRevision(){

            @Override
            public String getComment() {
                return "This is a comment that was left\non a commit message";
            }
        };
        WaybackSpec wb = new WaybackSpec();
        wb.setCommentSearchText("comment");
        Assert.assertTrue((String)"Single term search", (boolean)wb.matchesRevision((FileRevision)fileRev, false));
        wb.setCommentSearchText("blah");
        Assert.assertFalse((String)"Single non-existing term search", (boolean)wb.matchesRevision((FileRevision)fileRev, false));
        wb.setCommentSearchText("comment that");
        Assert.assertTrue((String)"Two consecutive existing terms", (boolean)wb.matchesRevision((FileRevision)fileRev, false));
        wb.setCommentSearchText("comment commit");
        Assert.assertTrue((String)"Two non-consecutive existing terms", (boolean)wb.matchesRevision((FileRevision)fileRev, false));
        wb.setCommentSearchText("comment blah");
        Assert.assertFalse((String)"Two consecutive non-existing terms", (boolean)wb.matchesRevision((FileRevision)fileRev, false));
        wb.setCommentSearchText("COMMENT ThAt");
        Assert.assertTrue((String)"Two consecutive existing terms case insensitive", (boolean)wb.matchesRevision((FileRevision)fileRev, false));
        wb.setCommentSearchText("comment   commit message ");
        Assert.assertTrue((String)"Non-consecutive existing terms with whitespace", (boolean)wb.matchesRevision((FileRevision)fileRev, false));
        wb.setCommentSearchText("comment   blah s message ");
        Assert.assertFalse((String)"Non-existing terms with whitespace", (boolean)wb.matchesRevision((FileRevision)fileRev, false));
        wb.setCommentSearchText("    ");
        Assert.assertTrue((String)"Whitespace search should match", (boolean)wb.matchesRevision((FileRevision)fileRev, false));
    }

    @Test
    public void testMatchesWhenIgnoringBranchConstraints() throws Exception {
        DummyFileRevision defaultFileRev = new DummyFileRevision(){

            @Override
            public List<String> getBranchPoints() {
                return Collections.emptyList();
            }
        };
        DummyFileRevision myBranchFileRev = new DummyFileRevision(){

            @Override
            public String getBranch() {
                return "mybranch";
            }

            @Override
            public List<String> getBranchPoints() {
                return Collections.singletonList(this.getBranch());
            }
        };
        WaybackSpec wb = new WaybackSpec();
        wb.setBranch("mybranch");
        Assert.assertFalse((String)"wbs shouldn't match file revision when branch constraint set", (boolean)wb.matchesRevision((FileRevision)defaultFileRev, false));
        Assert.assertTrue((String)"wbs should match file revision when branch constraint set", (boolean)wb.matchesRevision((FileRevision)myBranchFileRev, false));
        Assert.assertTrue((String)"wbs should match file revision when branch constraint set but ignoring it", (boolean)wb.matchesRevision((FileRevision)defaultFileRev, true));
        Assert.assertTrue((String)"wbs should match file revision when branch constraint set but ignoring it", (boolean)wb.matchesRevision((FileRevision)myBranchFileRev, true));
    }

    @Test
    public void testMatchesWhenIgnoringTagConstraints() throws Exception {
        DummyFileRevision defaultFileRev = new DummyFileRevision(){

            @Override
            public List<String> getTags() {
                return Collections.emptyList();
            }
        };
        DummyFileRevision myTagFileRev = new DummyFileRevision(){

            @Override
            public List<String> getTags() {
                return Collections.singletonList("mytag");
            }
        };
        WaybackSpec wb = new WaybackSpec();
        wb.setTag("mytag");
        Assert.assertFalse((String)"wbs shouldn't match file revision when tag constraint set", (boolean)wb.matchesRevision((FileRevision)defaultFileRev, false));
        Assert.assertTrue((String)"wbs should match file revision when tag constraint set", (boolean)wb.matchesRevision((FileRevision)myTagFileRev, false));
        Assert.assertTrue((String)"wbs should match file revision when tag constraint set but ignoring it", (boolean)wb.matchesRevision((FileRevision)defaultFileRev, true));
        Assert.assertTrue((String)"wbs should match file revision when tag constraint set but ignoring it", (boolean)wb.matchesRevision((FileRevision)myTagFileRev, true));
    }

    @Test
    public void testMatchesAuthorConstraints() throws Exception {
        DummyFileRevision fileRev = new DummyFileRevision(){

            @Override
            public String getAuthor() {
                return "sruiz";
            }
        };
        WaybackSpec wb = new WaybackSpec();
        wb.setAuthor("sruiz");
        Assert.assertTrue((String)"Case sensitive author match", (boolean)wb.matchesRevision((FileRevision)fileRev, false));
        wb.setAuthor("SRUIZ");
        Assert.assertTrue((String)"Case insensitive author match", (boolean)wb.matchesRevision((FileRevision)fileRev, false));
        wb.setAuthor("panda");
        Assert.assertFalse((String)"Case sensitive author email match", (boolean)wb.matchesRevision((FileRevision)fileRev, false));
        DummyFileRevision emailAuthorRev = new DummyFileRevision(){

            @Override
            public String getAuthor() {
                return "Seb Ruiz <sruiz@atlassian.com>";
            }
        };
        wb.setAuthor("Seb Ruiz <sruiz@atlassian.com>");
        Assert.assertTrue((String)"Case sensitive author email match", (boolean)wb.matchesRevision((FileRevision)emailAuthorRev, false));
        wb.setAuthor("seb ruiz <sruiz@atlassian.com>");
        Assert.assertTrue((String)"Case insensitive author email match", (boolean)wb.matchesRevision((FileRevision)emailAuthorRev, false));
        wb.setAuthor("seb ruiz");
        Assert.assertFalse((String)"Case sensitive author name match", (boolean)wb.matchesRevision((FileRevision)emailAuthorRev, false));
    }

    @Test
    public void testRemoveWbSpec() throws Exception {
        WaybackSpec wb = new WaybackSpec();
        Assert.assertEquals((String)"blah=blah", (String)wb.removeWbFromQueryString("wbbr=branch&blah=blah"));
        Assert.assertEquals((String)"blah=blah", (String)wb.removeWbFromQueryString("blah=blah&wbbr=branch"));
        Assert.assertEquals((String)"blah=blah&blah=blah", (String)wb.removeWbFromQueryString("blah=blah&wbbr=branch&blah=blah"));
        Assert.assertEquals((String)"", (String)wb.removeWbFromQueryString("wbbr=branch"));
        Assert.assertEquals((String)"wbbr=branch", (String)wb.removeWbFromQueryString("wbbr=branch&wbbr=branch"));
        Assert.assertEquals((String)"blah=blah", (String)wb.removeWbFromQueryString("wbbr=branch&blah=blah&wbbr=branch"));
        Assert.assertEquals((String)"notwbbr=branch&blah=blah", (String)wb.removeWbFromQueryString("notwbbr=branch&blah=blah"));
    }

    @Test
    public void testGetBranchOrTag() throws Exception {
        WaybackSpec wb = new WaybackSpec();
        Assert.assertNull((String)"branch and tag should be null", (Object)wb.getBranchOrTag());
        wb.setTag("tag");
        Assert.assertEquals((String)"tag", (String)wb.getBranchOrTag());
        wb.setBranch("branch");
        Assert.assertEquals((String)"branch", (String)wb.getBranchOrTag());
        wb.setBranch(null);
        Assert.assertEquals((String)"tag", (String)wb.getBranchOrTag());
        wb.setTag("");
        Assert.assertNull((String)"branch and tag should be null", (Object)wb.getBranchOrTag());
    }
}

