/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.web.ViewFileAction;
import com.cenqua.fisheye.web.mime.ContentDispositionHeaderGuesser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.easymock.classextension.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ViewFileActionNextAndPrevRevisionTest {
    private ViewFileAction action;
    private FileHistory history;
    private List<FileRevision> revisions;
    private FileRevision r1;
    private FileRevision r2a;
    private FileRevision r2b;
    private FileRevision r3;
    private FileRevision r4;
    private ContentDispositionHeaderGuesser contentDispositionHeaderGuesser;

    private FileRevision createFileRevision(String path, String revision, FileRevision diffRevision, FileRevision ... ancestors) {
        FileRevision rev = (FileRevision)EasyMock.createMock(FileRevision.class);
        RevInfoKey revKey = new RevInfoKey(new Path((CharSequence)path), revision);
        ArrayList<RevInfoKey> ancKeys = new ArrayList<RevInfoKey>();
        for (FileRevision ancestor : ancestors) {
            ancKeys.add(ancestor.getRevInfoKey());
        }
        EasyMock.expect((Object)rev.getRevInfoKey()).andReturn((Object)revKey).anyTimes();
        EasyMock.expect((Object)rev.getPath()).andReturn((Object)new Path((CharSequence)path)).anyTimes();
        EasyMock.expect((Object)rev.getRevision()).andReturn((Object)revision).anyTimes();
        EasyMock.expect((Object)rev.getAncestors()).andReturn(ancKeys).anyTimes();
        EasyMock.expect((Object)rev.getDiffRevision()).andReturn((Object)(diffRevision != null ? diffRevision.getRevInfoKey() : null)).anyTimes();
        EasyMock.replay((Object[])new Object[]{rev});
        return rev;
    }

    @Before
    public void init() {
        this.contentDispositionHeaderGuesser = (ContentDispositionHeaderGuesser)EasyMock.createMock(ContentDispositionHeaderGuesser.class);
        this.action = new ViewFileAction(null, this.contentDispositionHeaderGuesser);
        this.history = (FileHistory)EasyMock.createMock(FileHistory.class);
        this.r1 = this.createFileRevision("file.txt", "rev1", null, new FileRevision[0]);
        this.r2a = this.createFileRevision("file.txt", "rev2a", this.r1, this.r1);
        this.r2b = this.createFileRevision("file.txt", "rev2b", this.r1, this.r1);
        this.r3 = this.createFileRevision("file.txt", "rev3", this.r2a, this.r2a, this.r2b);
        this.r4 = this.createFileRevision("moved.txt", "rev4", this.r3, this.r3);
        this.revisions = Arrays.asList(this.r1, this.r2a, this.r2b, this.r3, this.r4);
        ArrayList<FileRevision> sortedRevs = new ArrayList<FileRevision>(this.revisions);
        Collections.reverse(sortedRevs);
        EasyMock.expect((Object)this.history.getRevisions()).andReturn(this.revisions).anyTimes();
        EasyMock.expect((Object)this.history.getRevisionsSorted()).andReturn(sortedRevs).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.history});
    }

    @Test
    public void testPreviousWithNull() {
        Assert.assertNull((Object)this.action.getPreviousRevision(null));
        Assert.assertNull((Object)this.action.getPreviousRevision(null));
        Assert.assertNotNull((Object)this.action.getPreviousRevision(this.r3));
    }

    @Test
    public void testNextWithNull() {
        Assert.assertNull((Object)this.action.getNextRevision(null, null));
        Assert.assertNull((Object)this.action.getNextRevision(this.history, null));
        Assert.assertNull((Object)this.action.getNextRevision(null, this.r3));
    }

    @Test
    public void testPrevious() {
        Assert.assertEquals((Object)this.r2a.getRevision(), (Object)this.action.getPreviousRevision(this.r3));
        Assert.assertEquals((Object)this.r1.getRevision(), (Object)this.action.getPreviousRevision(this.r2b));
        Assert.assertEquals((Object)this.r1.getRevision(), (Object)this.action.getPreviousRevision(this.r2a));
        Assert.assertEquals(null, (Object)this.action.getPreviousRevision(this.r1));
    }

    @Test
    public void testNext() {
        Assert.assertEquals(null, (Object)this.action.getNextRevision(this.history, this.r3));
        Assert.assertEquals((Object)this.r3.getRevision(), (Object)this.action.getNextRevision(this.history, this.r2b));
        Assert.assertEquals((Object)this.r3.getRevision(), (Object)this.action.getNextRevision(this.history, this.r2a));
        Assert.assertEquals((Object)this.r2b.getRevision(), (Object)this.action.getNextRevision(this.history, this.r1));
    }
}

