/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.web.CommandString;
import com.cenqua.fisheye.web.WaybackSpec;
import junit.framework.TestCase;

public class TestCommandStringEncode
extends TestCase {
    public void testUrlEncode() {
        WaybackSpec wbs = new WaybackSpec();
        wbs.setAuthor("mc/slashy//");
        String encoded = wbs.getUrlCommandParams();
        TestCommandStringEncode.assertEquals((String)"author=mc%402fslashy%402f%402f", (String)encoded);
        wbs.setAuthor("@@mc@attie@@");
        encoded = wbs.getUrlCommandParams();
        TestCommandStringEncode.assertEquals((String)"author=%4040%4040mc%4040attie%4040%4040", (String)encoded);
        wbs.setAuthor("@/mc//@//SlashHappy@/");
        encoded = wbs.getUrlCommandParams();
        TestCommandStringEncode.assertEquals((String)"author=%4040%402fmc%402f%402f%4040%402f%402fSlashHappy%4040%402f", (String)encoded);
    }

    public void testUrlDecode() {
        CommandString str = new CommandString("author=mc@2Fslashy");
        TestCommandStringEncode.assertEquals((String)"author=mc/slashy", (String)str.toString());
        str = new CommandString("author=mc@2Fsl@40ashy");
        TestCommandStringEncode.assertEquals((String)"author=mc/sl@ashy", (String)str.toString());
        str = new CommandString("author=mc@40@2F@40@2Fslashy");
        TestCommandStringEncode.assertEquals((String)"author=mc@/@/slashy", (String)str.toString());
    }
}

