/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.web.ServletUtils;
import java.io.IOException;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class ServletUtilsTest
extends TestCase {
    public void testSendRedirectFrom() throws IOException {
        MockHttpServletResponse response = new MockHttpServletResponse();
        ServletUtils.sendRedirectFrom((HttpServletResponse)response, (String)"/admin/admin.do#repositories-stash", (String)"login");
        Assert.assertEquals((Object)"/admin/admin.do?_redir=login#repositories-stash", (Object)response.getRedirectedUrl());
        response = new MockHttpServletResponse();
        ServletUtils.sendRedirectFrom((HttpServletResponse)response, (String)"/admin/admin.do", (String)"login");
        Assert.assertEquals((Object)"/admin/admin.do?_redir=login", (Object)response.getRedirectedUrl());
        response = new MockHttpServletResponse();
        ServletUtils.sendRedirectFrom((HttpServletResponse)response, (String)"/admin/admin.do?thing=blah#repositories-stash", (String)"login");
        Assert.assertEquals((Object)"/admin/admin.do?thing=blah&_redir=login#repositories-stash", (Object)response.getRedirectedUrl());
        response = new MockHttpServletResponse();
        ServletUtils.sendRedirectFrom((HttpServletResponse)response, (String)"/admin/admin.do?thing=blah", (String)"login");
        Assert.assertEquals((Object)"/admin/admin.do?thing=blah&_redir=login", (Object)response.getRedirectedUrl());
        response = new MockHttpServletResponse();
        ServletUtils.sendRedirectFrom((HttpServletResponse)response, (String)"/admin/admin.do#", (String)"login");
        Assert.assertEquals((Object)"/admin/admin.do?_redir=login#", (Object)response.getRedirectedUrl());
    }

    public void testToQueryString() {
        LinkedHashMap<String, String[]> paramMap = new LinkedHashMap<String, String[]>();
        ServletUtilsTest.assertEquals((String)"", (String)ServletUtils.toQueryString(paramMap));
        paramMap.put("stars", new String[]{"sol"});
        ServletUtilsTest.assertEquals((String)"?stars=sol", (String)ServletUtils.toQueryString(paramMap));
        paramMap.put("planets", new String[]{"mercury", "venus", "earth"});
        ServletUtilsTest.assertEquals((String)"?stars=sol&planets=mercury&planets=venus&planets=earth", (String)ServletUtils.toQueryString(paramMap));
        paramMap.put("stellars", new String[0]);
        ServletUtilsTest.assertEquals((String)"?stars=sol&planets=mercury&planets=venus&planets=earth", (String)ServletUtils.toQueryString(paramMap));
    }

    public void testGetClosestGETUrlReviewAction() {
        this.testGetClosestGETUrl("/bar", "/bar/cru/CR-1/join", "/bar/cru/CR-1", null);
    }

    public void testGetClosestGETUrlAdminAction() {
        this.testGetClosestGETUrl("/bar", "/bar/admin/editSysAdmins-modify.do", "/bar/admin/", null);
    }

    public void testGetClosestGETUrlFallback() {
        this.testGetClosestGETUrl("/bar", "/bar/fakeRequest.do", "/bar", null);
    }

    public void testGetClosestGETUrlReviewActionOriginalUri() {
        this.testGetClosestGETUrl("/bar", "/bar/internal.do", "/bar/cru/CR-1", "/bar/cru/CR-1/join");
    }

    private void testGetClosestGETUrl(String contextPath, String uri, String expected, String originalUri) {
        MockHttpServletRequest request = new MockHttpServletRequest("GET", uri);
        request.setContextPath(contextPath);
        request.setAttribute("fisheye.forward.request_uri", (Object)originalUri);
        String closestUrl = ServletUtils.getClosestGETUrl((HttpServletRequest)request);
        Assert.assertThat((String)("Uri " + request.getRequestURI() + " original uri " + request.getAttribute("fisheye.forward.request_uri")), (Object)closestUrl, (Matcher)Matchers.is((Object)expected));
    }
}

