/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fisheye.util.MockTestFileRevision;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.util.DummyReviewManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DummyRevisionCache;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.search.SimpleSearchResults;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.search.query.FishQueryTest;
import com.cenqua.fisheye.web.SearchResultsExplorer;
import com.cenqua.fisheye.web.paging.TotalCountAwarePagingCalculator;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

public class SearchResultsExplorerTest
extends TestCase {
    private static final String MAX_LINES_ADDED = "maxLinesAdded";
    private static final String MAX_LINES_REMOVED = "maxLinesRemoved";
    private static final String MAX_TOTAL_LINES = "maxTotalLines";
    private static final String MIN_LINES_ADDED = "minLinesAdded";
    private static final String MIN_LINES_REMOVED = "minLinesRemoved";
    private static final String MIN_TOTAL_LINES = "minTotalLines";
    private static final String AVERAGE_LINES_ADDED = "averageLinesAdded";
    private static final String AVERAGE_LINES_REMOVED = "averageLinesRemoved";
    private static final String AVERAGE_TOTAL_LINES = "averageTotalLines";
    private static final String SUM_LINES_ADDED = "sumLinesAdded";
    private static final String SUM_LINES_REMOVED = "sumLinesRemoved";
    private static final String SUM_TOTAL_LINES = "sumTotalLines";
    private static final String COUNT_REVISION = "countRevision";
    private static final String COUNT_IS_BINARY = "countIsBinary";
    private static final String COUNT_IS_ADDED = "countIsAdded";
    private static final String COUNT_IS_DELETED = "countIsDeleted";
    private static final String COUNT_IS_COPIED = "countIsCopied";
    private static final String COUNT_IS_MOVED = "countIsMoved";
    private static final String COUNT_PATH = "countPath";
    private static final String COUNT_AUTHOR = "countAuthor";
    private static final String COUNT_DATE = "countDate";
    private static final String COUNT_CSID = "countCsid";
    private static final String COUNT_TAGS = "countTags";
    private static final String COUNT_REVIEWS = "countReviews";
    private static final String COUNT_DIR = "countDir";

    protected void setUp() throws Exception {
        super.setUp();
        DefaultReviewManager.set((ReviewManager)new DummyReviewManager());
    }

    private IntList revisionIntList(FileRevision[] revisions, Function<FileRevision, String> selector) {
        Comparator comparator = (o1, o2) -> ((String)selector.apply(o1)).compareTo((String)selector.apply(o2));
        Arrays.sort(revisions, comparator);
        IntArrayList al = new IntArrayList();
        for (FileRevision revision : revisions) {
            al.add(revision.getRevID());
        }
        return al;
    }

    private Object[] groupStarts(FileRevision[] revisions, Function<FileRevision, String> selector) {
        Object[] groups = new Object[revisions.length];
        String group = null;
        for (int i = 0; i < revisions.length; ++i) {
            String currentGroup = (String)selector.apply((Object)revisions[i]);
            if (currentGroup.equals(group)) continue;
            groups[i] = currentGroup;
            group = currentGroup;
        }
        return groups;
    }

    private SearchResultsExplorer getResultsFor(FileRevision[] revisions, FishQuery.GroupBy groupBy) {
        FishQuery fq = FishQueryTest.doParse("all", FishQueryTest.createFullQuery());
        fq.setGroupBy(groupBy);
        Function selector = from -> {
            switch (groupBy) {
                case FILE: {
                    return from.getPath().toString();
                }
                case DIRECTORY: {
                    return from.getPath().getParent().getPath();
                }
                case CHANGESET: {
                    return from.getChangeSetId();
                }
            }
            return "";
        };
        IntList revIds = this.revisionIntList(revisions, (Function<FileRevision, String>)selector);
        Object[] groups = this.groupStarts(revisions, (Function<FileRevision, String>)selector);
        SimpleSearchResults results = new SimpleSearchResults((RevisionCache)new MockRevisionCache(revisions), fq, "test", revIds, groupBy == FishQuery.GroupBy.NONE ? null : groups);
        SearchResultsExplorer explorer = new SearchResultsExplorer((SearchResults)results);
        explorer.setPagingCalculator(TotalCountAwarePagingCalculator.getPagingCalculator((int)1, (int)explorer.getSize(), (int)explorer.getSize()));
        return explorer;
    }

    public void testCalculates() throws Exception {
        final FileRevision[] revisions = new FileRevision[]{new MockTestFileRevision("foo/a.txt", "23", "matt", "2010/01/12", "345", 12, 3, 99).tags("foo"), new MockTestFileRevision("foo/a.txt", "24", "matt", "2010/01/12", "346", 2, 30, 71).tags("foobar"), new MockTestFileRevision("foo/a.txt", "25", "matt", "2010/01/12", "347", 9, 3, 77), new MockTestFileRevision("foo/a.txt", "26", "wilma", "2010/01/13", "348", 55, 8, 124), new MockTestFileRevision("foo/b.txt", "23", "matt", "2010/01/12", "345", 9, 22, 56).tags("foo"), new MockTestFileRevision("foo/b.txt", "24", "matt", "2010/01/12", "346", 34, 34, 56), new MockTestFileRevision("foo/c.txt", "25", "matt", "2010/01/12", "345", 12, 3, 99).tags("foo").reviews(1), new MockTestFileRevision("foo/c.txt", "26", "matt", "2010/01/12", "346", 12, 3, 99).reviews(1), new MockTestFileRevision("foo/c.txt", "27", "fred", "2010/01/14", "349", 12, 3, 99).reviews(1, 2), new MockTestFileRevision("foobar/a.txt", "23", "matt", "2010/01/12", "345", 87, 3, 98).tags("foo", "foobar"), new MockTestFileRevision("foobar/a.txt", "27", "fred", "2010/01/14", "349", 25, 12, 111), new MockTestFileRevision("foobar/a.txt", "29", "barney", "2010/01/15", "350", 44, 23, 132).tags("blah", "wibble", "flob"), new MockTestFileRevision("foobar/b.txt", "23", "matt", "2010/01/12", "345", 30, 0, 30).added().tags("foo"), new MockTestFileRevision("foobar/b.txt", "30", "matt", "2010/01/12", "346", 0, 30, 0).deleted(), new MockTestFileRevision("foobar/c.txt", "23", "matt", "2010/01/12", "345", 30, 0, 30).added().tags("foo"), new MockTestFileRevision("foobar/c.txt", "30", "matt", "2010/01/12", "346", 0, 30, 0).deleted(), new MockTestFileRevision("foobar/d.txt", "30", "dino", "2010/01/16", "351", 0, 0, 99).moved().reviews(2, 3), new MockTestFileRevision("foobar/e.txt", "30", "dino", "2010/01/16", "351", 0, 0, 99).moved(), new MockTestFileRevision("foobar/f.txt", "30", "dino", "2010/01/16", "351", 0, 0, 99).copied(), new MockTestFileRevision("foobar/g.txt", "30", "dino", "2010/01/16", "351", 0, 0, 99).copied().reviews(4), new MockTestFileRevision("foobar/g.txt", "30", "dino", "2010/01/16", "351", 0, 0, 99).copied(), new MockTestFileRevision("foobar/i.jpg", "30", "dino", "2010/01/16", "351", 3, 45, 90).added().binary(), new MockTestFileRevision("foobar/j.jpg", "30", "dino", "2010/01/16", "351", 3, 45, 90).added().binary()};
        HashMap<FishQuery.GroupBy, Map<String, int[]>> expectedGroupResults = new HashMap<FishQuery.GroupBy, Map<String, int[]>>(){
            {
                this.put(FishQuery.GroupBy.NONE, new HashMap<String, int[]>(){
                    {
                        this.put(SearchResultsExplorerTest.MAX_LINES_ADDED, new int[]{87});
                        this.put(SearchResultsExplorerTest.MAX_LINES_REMOVED, new int[]{45});
                        this.put(SearchResultsExplorerTest.MAX_TOTAL_LINES, new int[]{132});
                        this.put(SearchResultsExplorerTest.MIN_LINES_ADDED, new int[]{0});
                        this.put(SearchResultsExplorerTest.MIN_LINES_REMOVED, new int[]{0});
                        this.put(SearchResultsExplorerTest.MIN_TOTAL_LINES, new int[]{0});
                        this.put(SearchResultsExplorerTest.AVERAGE_LINES_ADDED, new int[]{16});
                        this.put(SearchResultsExplorerTest.AVERAGE_LINES_REMOVED, new int[]{12});
                        this.put(SearchResultsExplorerTest.AVERAGE_TOTAL_LINES, new int[]{80});
                        this.put(SearchResultsExplorerTest.SUM_LINES_ADDED, new int[]{379});
                        this.put(SearchResultsExplorerTest.SUM_LINES_REMOVED, new int[]{297});
                        this.put(SearchResultsExplorerTest.SUM_TOTAL_LINES, new int[]{1856});
                        this.put(SearchResultsExplorerTest.COUNT_REVISION, new int[]{revisions.length});
                        this.put(SearchResultsExplorerTest.COUNT_IS_BINARY, new int[]{2});
                        this.put(SearchResultsExplorerTest.COUNT_IS_ADDED, new int[]{4});
                        this.put(SearchResultsExplorerTest.COUNT_IS_DELETED, new int[]{2});
                        this.put(SearchResultsExplorerTest.COUNT_IS_COPIED, new int[]{3});
                        this.put(SearchResultsExplorerTest.COUNT_IS_MOVED, new int[]{2});
                        this.put(SearchResultsExplorerTest.COUNT_PATH, new int[]{12});
                        this.put(SearchResultsExplorerTest.COUNT_AUTHOR, new int[]{5});
                        this.put(SearchResultsExplorerTest.COUNT_DATE, new int[]{5});
                        this.put(SearchResultsExplorerTest.COUNT_CSID, new int[]{7});
                        this.put(SearchResultsExplorerTest.COUNT_TAGS, new int[]{5});
                        this.put(SearchResultsExplorerTest.COUNT_REVIEWS, new int[]{4});
                        this.put(SearchResultsExplorerTest.COUNT_DIR, new int[]{2});
                    }
                });
                this.put(FishQuery.GroupBy.CHANGESET, new HashMap<String, int[]>(){
                    {
                        this.put(SearchResultsExplorerTest.COUNT_CSID, new int[]{1, 1, 1, 1, 1, 1, 1});
                        this.put(SearchResultsExplorerTest.COUNT_DATE, new int[]{1, 1, 1, 1, 1, 1, 1});
                        this.put(SearchResultsExplorerTest.SUM_LINES_ADDED, new int[]{180, 48, 9, 55, 37, 44, 6});
                        this.put(SearchResultsExplorerTest.SUM_LINES_REMOVED, new int[]{31, 127, 3, 8, 15, 23, 90});
                        this.put(SearchResultsExplorerTest.AVERAGE_LINES_REMOVED, new int[]{5, 25, 3, 8, 7, 23, 12});
                        this.put(SearchResultsExplorerTest.COUNT_TAGS, new int[]{2, 1, 0, 0, 0, 3, 0});
                        this.put(SearchResultsExplorerTest.COUNT_PATH, new int[]{6, 5, 1, 1, 2, 1, 6});
                        this.put(SearchResultsExplorerTest.AVERAGE_LINES_ADDED, new int[]{30, 9, 9, 55, 18, 44, 0});
                        this.put(SearchResultsExplorerTest.MAX_TOTAL_LINES, new int[]{99, 99, 77, 124, 111, 132, 99});
                        this.put(SearchResultsExplorerTest.COUNT_AUTHOR, new int[]{1, 1, 1, 1, 1, 1, 1});
                        this.put(SearchResultsExplorerTest.MIN_LINES_ADDED, new int[]{9, 0, 9, 55, 12, 44, 0});
                        this.put(SearchResultsExplorerTest.MIN_TOTAL_LINES, new int[]{30, 0, 77, 124, 99, 132, 90});
                        this.put(SearchResultsExplorerTest.COUNT_REVISION, new int[]{6, 5, 1, 1, 2, 1, 7});
                        this.put(SearchResultsExplorerTest.COUNT_IS_ADDED, new int[]{2, 0, 0, 0, 0, 0, 2});
                        this.put(SearchResultsExplorerTest.AVERAGE_TOTAL_LINES, new int[]{68, 45, 77, 124, 105, 132, 96});
                        this.put(SearchResultsExplorerTest.COUNT_IS_COPIED, new int[]{0, 0, 0, 0, 0, 0, 3});
                        this.put(SearchResultsExplorerTest.MIN_LINES_REMOVED, new int[]{0, 3, 3, 8, 3, 23, 0});
                        this.put(SearchResultsExplorerTest.SUM_TOTAL_LINES, new int[]{412, 226, 77, 124, 210, 132, 675});
                        this.put(SearchResultsExplorerTest.COUNT_IS_MOVED, new int[]{0, 0, 0, 0, 0, 0, 2});
                        this.put(SearchResultsExplorerTest.MAX_LINES_ADDED, new int[]{87, 34, 9, 55, 25, 44, 3});
                        this.put(SearchResultsExplorerTest.COUNT_IS_BINARY, new int[]{0, 0, 0, 0, 0, 0, 2});
                        this.put(SearchResultsExplorerTest.MAX_LINES_REMOVED, new int[]{22, 34, 3, 8, 12, 23, 45});
                        this.put(SearchResultsExplorerTest.COUNT_REVIEWS, new int[]{1, 1, 0, 0, 2, 0, 3});
                        this.put(SearchResultsExplorerTest.COUNT_IS_DELETED, new int[]{0, 2, 0, 0, 0, 0, 0});
                        this.put(SearchResultsExplorerTest.COUNT_DIR, new int[]{2, 2, 1, 1, 2, 1, 1});
                    }
                });
                this.put(FishQuery.GroupBy.DIRECTORY, new HashMap<String, int[]>(){
                    {
                        this.put(SearchResultsExplorerTest.COUNT_CSID, new int[]{5, 5});
                        this.put(SearchResultsExplorerTest.COUNT_DATE, new int[]{3, 4});
                        this.put(SearchResultsExplorerTest.SUM_LINES_ADDED, new int[]{157, 222});
                        this.put(SearchResultsExplorerTest.SUM_LINES_REMOVED, new int[]{109, 188});
                        this.put(SearchResultsExplorerTest.AVERAGE_LINES_REMOVED, new int[]{12, 13});
                        this.put(SearchResultsExplorerTest.COUNT_TAGS, new int[]{2, 5});
                        this.put(SearchResultsExplorerTest.COUNT_PATH, new int[]{3, 9});
                        this.put(SearchResultsExplorerTest.AVERAGE_LINES_ADDED, new int[]{17, 15});
                        this.put(SearchResultsExplorerTest.MAX_TOTAL_LINES, new int[]{124, 132});
                        this.put(SearchResultsExplorerTest.COUNT_AUTHOR, new int[]{3, 4});
                        this.put(SearchResultsExplorerTest.MIN_LINES_ADDED, new int[]{2, 0});
                        this.put(SearchResultsExplorerTest.MIN_TOTAL_LINES, new int[]{56, 0});
                        this.put(SearchResultsExplorerTest.COUNT_REVISION, new int[]{9, 14});
                        this.put(SearchResultsExplorerTest.COUNT_IS_ADDED, new int[]{0, 4});
                        this.put(SearchResultsExplorerTest.AVERAGE_TOTAL_LINES, new int[]{86, 76});
                        this.put(SearchResultsExplorerTest.COUNT_IS_COPIED, new int[]{0, 3});
                        this.put(SearchResultsExplorerTest.MIN_LINES_REMOVED, new int[]{3, 0});
                        this.put(SearchResultsExplorerTest.SUM_TOTAL_LINES, new int[]{780, 1076});
                        this.put(SearchResultsExplorerTest.COUNT_IS_MOVED, new int[]{0, 2});
                        this.put(SearchResultsExplorerTest.MAX_LINES_ADDED, new int[]{55, 87});
                        this.put(SearchResultsExplorerTest.COUNT_IS_BINARY, new int[]{0, 2});
                        this.put(SearchResultsExplorerTest.MAX_LINES_REMOVED, new int[]{34, 45});
                        this.put(SearchResultsExplorerTest.COUNT_REVIEWS, new int[]{2, 3});
                        this.put(SearchResultsExplorerTest.COUNT_IS_DELETED, new int[]{0, 2});
                        this.put(SearchResultsExplorerTest.COUNT_DIR, new int[]{1, 1});
                    }
                });
                this.put(FishQuery.GroupBy.FILE, new HashMap<String, int[]>(){
                    {
                        this.put(SearchResultsExplorerTest.COUNT_CSID, new int[]{4, 2, 3, 3, 2, 2, 1, 1, 1, 1, 1, 1});
                        this.put(SearchResultsExplorerTest.COUNT_DATE, new int[]{2, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1});
                        this.put(SearchResultsExplorerTest.SUM_LINES_ADDED, new int[]{78, 43, 36, 156, 30, 30, 0, 0, 0, 0, 3, 3});
                        this.put(SearchResultsExplorerTest.SUM_LINES_REMOVED, new int[]{44, 56, 9, 38, 30, 30, 0, 0, 0, 0, 45, 45});
                        this.put(SearchResultsExplorerTest.AVERAGE_LINES_REMOVED, new int[]{11, 28, 3, 12, 15, 15, 0, 0, 0, 0, 45, 45});
                        this.put(SearchResultsExplorerTest.COUNT_TAGS, new int[]{2, 1, 1, 5, 1, 1, 0, 0, 0, 0, 0, 0});
                        this.put(SearchResultsExplorerTest.COUNT_PATH, new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
                        this.put(SearchResultsExplorerTest.AVERAGE_LINES_ADDED, new int[]{19, 21, 12, 52, 15, 15, 0, 0, 0, 0, 3, 3});
                        this.put(SearchResultsExplorerTest.MAX_TOTAL_LINES, new int[]{124, 56, 99, 132, 30, 30, 99, 99, 99, 99, 90, 90});
                        this.put(SearchResultsExplorerTest.COUNT_AUTHOR, new int[]{2, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1});
                        this.put(SearchResultsExplorerTest.MIN_LINES_ADDED, new int[]{2, 9, 12, 25, 0, 0, 0, 0, 0, 0, 3, 3});
                        this.put(SearchResultsExplorerTest.MIN_TOTAL_LINES, new int[]{71, 56, 99, 98, 0, 0, 99, 99, 99, 99, 90, 90});
                        this.put(SearchResultsExplorerTest.COUNT_REVISION, new int[]{4, 2, 3, 3, 2, 2, 1, 1, 1, 2, 1, 1});
                        this.put(SearchResultsExplorerTest.COUNT_IS_ADDED, new int[]{0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1});
                        this.put(SearchResultsExplorerTest.AVERAGE_TOTAL_LINES, new int[]{92, 56, 99, 113, 15, 15, 99, 99, 99, 99, 90, 90});
                        this.put(SearchResultsExplorerTest.COUNT_IS_COPIED, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0});
                        this.put(SearchResultsExplorerTest.MIN_LINES_REMOVED, new int[]{3, 22, 3, 3, 0, 0, 0, 0, 0, 0, 45, 45});
                        this.put(SearchResultsExplorerTest.SUM_TOTAL_LINES, new int[]{371, 112, 297, 341, 30, 30, 99, 99, 99, 198, 90, 90});
                        this.put(SearchResultsExplorerTest.COUNT_IS_MOVED, new int[]{0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0});
                        this.put(SearchResultsExplorerTest.MAX_LINES_ADDED, new int[]{55, 34, 12, 87, 30, 30, 0, 0, 0, 0, 3, 3});
                        this.put(SearchResultsExplorerTest.COUNT_IS_BINARY, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1});
                        this.put(SearchResultsExplorerTest.MAX_LINES_REMOVED, new int[]{30, 34, 3, 23, 30, 30, 0, 0, 0, 0, 45, 45});
                        this.put(SearchResultsExplorerTest.COUNT_REVIEWS, new int[]{0, 0, 2, 0, 0, 0, 2, 0, 0, 1, 0, 0});
                        this.put(SearchResultsExplorerTest.COUNT_IS_DELETED, new int[]{0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0});
                        this.put(SearchResultsExplorerTest.COUNT_DIR, new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
                    }
                });
            }
        };
        for (FishQuery.GroupBy groupBy : FishQuery.GroupBy.values()) {
            this.runTestForGrouping(revisions, (Map)expectedGroupResults.get(groupBy), groupBy);
        }
    }

    private void runTestForGrouping(FileRevision[] revisions, Map<String, int[]> stringMap, FishQuery.GroupBy groupBy) throws Exception {
        boolean generate = false;
        SearchResultsExplorer explorer = this.getResultsFor(revisions, groupBy);
        SearchResultsExplorer.TabularRowDetailIterator rows = explorer.getTabularRows();
        int rowCount = 0;
        while (rows.hasNext()) {
            ++rowCount;
            SearchResultsExplorer.RowDetail row = rows.next();
            for (SearchResultsExplorer.CellDetail cell : row.getColumns()) {
                SearchResultsExplorerTest.assertEquals((String)("groupBy:" + groupBy + ";group:" + row.getGroupTitle() + ";cell:" + cell.getColumnName()), (int)stringMap.get(cell.getColumnName())[rowCount - 1], (int)cell.getAsInt());
            }
        }
        SearchResultsExplorerTest.assertEquals((String)("groupBy:" + groupBy), (int)stringMap.get(COUNT_REVISION).length, (int)rowCount);
    }

    private int[] extendByOne(int[] ints) {
        int[] newInts = new int[ints.length + 1];
        for (int i = 0; i < ints.length; ++i) {
            newInts[i] = ints[i];
        }
        return newInts;
    }

    private static class MockRevisionCache
    extends DummyRevisionCache {
        private Map<Integer, FileRevision> revisions = Maps.newHashMap();

        private MockRevisionCache(FileRevision[] revisions) {
            for (FileRevision revision : revisions) {
                this.revisions.put(revision.getRevID(), revision);
            }
        }

        @Override
        public FileRevision getFileRevision(int revid) throws DbException {
            return this.revisions.get(revid);
        }

        @Override
        public FileRevision findFileRevision(Path path, String revision) throws DbException {
            return null;
        }
    }
}

