/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.cvsrep.FisheyeSanityTestBase;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.mail.MailerTestUtils;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.user.UserManager;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.util.GreenMail;
import java.math.BigInteger;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;

public abstract class MailEnabledTestBase
extends FisheyeSanityTestBase {
    protected final GreenMail greenmail = MailerTestUtils.getGreenmailServer();
    protected UserManager um;
    protected Mailer mailer;
    protected static final int CHANGES_IN_STAGE1 = 12;
    protected static final long MAX_WAIT_TIME_PER_EMAIL = 5000L;
    protected static final String USERNAME = "watchmanagertest";
    protected static final String USERNAME_EMAIL = "watchmanagertest@lowercase.com";
    protected static final String USERNAME_2 = "otheruser";
    protected static final String USERNAME_2_EMAIL = "otheruser@uppercase.com";
    protected static final String PASSWORD = "test";

    @Override
    @Before
    public void setUp() throws Exception {
        MailEnabledTestBase.fisheyeSetUp();
        super.setUp();
        this.um = (UserManager)SpringContext.getComponentByClass(UserManager.class);
        ConfigDocument.Config config = AppConfig.getsConfig().getConfig();
        this.mailer = (Mailer)SpringContext.getComponentByClass(Mailer.class);
        config.getSmtp().setDebug(true);
        config.getSmtp().setPort(new BigInteger(MailerTestUtils.PORT.toString()));
        config.getSmtp().setHost(MailerTestUtils.HOST);
        this.mailer.reload(config.getSmtp());
        this.setupUser(USERNAME, PASSWORD, USERNAME_EMAIL);
        this.setupUser(USERNAME_2, PASSWORD, USERNAME_2_EMAIL);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            this.deleteUser(USERNAME);
            this.deleteUser(USERNAME_2);
        }
        finally {
            HibernateUtil.closeSession();
            super.tearDown();
            MailEnabledTestBase.fisheyeTearDown();
        }
    }

    @Override
    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.reslurpAndGetSanity1Repos2();
    }

    protected void setupUser(String username, String password, String testEmail) throws DbException, LicensePolicyException {
        this.userPermissionsTestRule.addFecruUser(username, username, testEmail);
        this.greenmail.setUser(testEmail, username, password);
    }

    protected void deleteUser(String username) throws DbException {
        FecruUser feUser = this.um.getLicensedUser(username);
        if (feUser != null) {
            this.um.deleteUserFully(username);
        }
    }

    protected void deleteEmail() throws FolderException {
        Assert.assertEquals((int)0, (int)MailerTestUtils.cleanInbox(USERNAME));
        Assert.assertEquals((int)0, (int)MailerTestUtils.cleanInbox(USERNAME_2));
    }
}

